/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.resolver.sql;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.api.MigrationType;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.resolver.MigrationInfoHelper;
import com.googlecode.flyway.core.resolver.MigrationResolver;
import com.googlecode.flyway.core.resolver.ResolvedMigration;
import com.googlecode.flyway.core.resolver.sql.SqlMigrationExecutor;
import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.Pair;
import com.googlecode.flyway.core.util.PlaceholderReplacer;
import com.googlecode.flyway.core.util.scanner.ClassPathScanner;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.zip.CRC32;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SqlMigrationResolver
implements MigrationResolver {
    private final String location;
    private final PlaceholderReplacer placeholderReplacer;
    private final String encoding;
    private final String sqlMigrationPrefix;
    private final String sqlMigrationSuffix;

    public SqlMigrationResolver(String location, PlaceholderReplacer placeholderReplacer, String encoding, String sqlMigrationPrefix, String sqlMigrationSuffix) {
        this.location = location;
        this.placeholderReplacer = placeholderReplacer;
        this.encoding = encoding;
        this.sqlMigrationPrefix = sqlMigrationPrefix;
        this.sqlMigrationSuffix = sqlMigrationSuffix;
    }

    @Override
    public List<ResolvedMigration> resolveMigrations() {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        try {
            ClassPathResource[] resources;
            for (ClassPathResource resource : resources = new ClassPathScanner().scanForResources(this.location, this.sqlMigrationPrefix, this.sqlMigrationSuffix)) {
                ResolvedMigration resolvedMigration = this.extractMigrationInfo(resource);
                resolvedMigration.setPhysicalLocation(resource.getLocationOnDisk());
                resolvedMigration.setExecutor(new SqlMigrationExecutor(resource, this.placeholderReplacer, this.encoding));
                migrations.add(resolvedMigration);
            }
        }
        catch (IOException e) {
            throw new FlywayException("Unable to scan for SQL migrations in location: " + this.location, e);
        }
        Collections.sort(migrations);
        return migrations;
    }

    private ResolvedMigration extractMigrationInfo(ClassPathResource resource) {
        ResolvedMigration migration = new ResolvedMigration();
        Pair<MigrationVersion, String> info = MigrationInfoHelper.extractVersionAndDescription(resource.getFilename(), this.sqlMigrationPrefix, this.sqlMigrationSuffix);
        migration.setVersion(info.getLeft());
        migration.setDescription(info.getRight());
        String scriptName = resource.getLocation().substring(resource.getLocation().indexOf(this.location) + this.location.length() + "/".length());
        migration.setScript(scriptName);
        migration.setChecksum(SqlMigrationResolver.calculateChecksum(resource.loadAsBytes()));
        migration.setType(MigrationType.SQL);
        return migration;
    }

    static String extractVersionStringFromFileName(String fileName, String prefix, String suffix) {
        int extension;
        int lastDirSeparator = fileName.lastIndexOf("/");
        String withoutPathAndSuffix = fileName.substring(lastDirSeparator + 1, extension = fileName.lastIndexOf(suffix));
        if (withoutPathAndSuffix.startsWith(prefix)) {
            return withoutPathAndSuffix.substring(prefix.length());
        }
        return withoutPathAndSuffix;
    }

    private static int calculateChecksum(byte[] bytes) {
        CRC32 crc32 = new CRC32();
        crc32.update(bytes);
        return (int)crc32.getValue();
    }
}

