/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.ant;

import com.googlecode.flyway.ant.AbstractFlywayTask;
import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.validation.ValidationErrorMode;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.Task;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractMigrationLoadingTask
extends AbstractFlywayTask {
    private static final String PLACEHOLDERS_PROPERTY_PREFIX = "flyway.placeholders.";
    private String[] locations;
    private String basePackage;
    private String baseDir;
    private String encoding;
    private String sqlMigrationPrefix;
    private String sqlMigrationSuffix;
    @Deprecated
    private String validationErrorMode;
    private boolean cleanOnValidationError;
    private String target;
    private boolean outOfOrder;
    private Map<String, String> placeholders = new HashMap<String, String>();
    private String placeholderPrefix;
    private String placeholderSuffix;

    public void addConfiguredLocations(Locations locations) {
        this.locations = locations.locations.toArray(new String[locations.locations.size()]);
    }

    @Deprecated
    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    @Deprecated
    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setSqlMigrationPrefix(String sqlMigrationPrefix) {
        this.sqlMigrationPrefix = sqlMigrationPrefix;
    }

    public void setSqlMigrationSuffix(String sqlMigrationSuffix) {
        this.sqlMigrationSuffix = sqlMigrationSuffix;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    @Deprecated
    public void setValidationErrorMode(String validationErrorMode) {
        this.validationErrorMode = validationErrorMode;
    }

    public void setCleanOnValidationError(boolean cleanOnValidationError) {
        this.cleanOnValidationError = cleanOnValidationError;
    }

    public void setOutOfOrder(boolean outOfOrder) {
        this.outOfOrder = outOfOrder;
    }

    public void setPlaceholderPrefix(String placeholderPrefix) {
        this.placeholderPrefix = placeholderPrefix;
    }

    public void setPlaceholderSuffix(String placeholderSuffix) {
        this.placeholderSuffix = placeholderSuffix;
    }

    @Deprecated
    public void addConfiguredPlaceholder(PlaceholderElement placeholder) {
        this.getProject().log((Task)this, "The direct use of <placeholder> is deprecated. They should be nested inside a <placeholders> element. Support for this will be removed in Flyway 3.0.", null, 1);
        this.placeholders.put(placeholder.name, placeholder.value);
    }

    public void addConfiguredPlaceholders(PlaceholdersElement placeholders) {
        this.placeholders = placeholders.placeholders;
    }

    @Override
    protected final void doExecute(Flyway flyway) throws Exception {
        String placeholderSuffixValue;
        String validationErrorModeValue;
        String sqlMigrationSuffixValue;
        String sqlMigrationPrefixValue;
        String encodingValue;
        String baseDirValue;
        String locationsProperty = this.getProject().getProperty("flyway.locations");
        if (locationsProperty != null) {
            flyway.setLocations(StringUtils.tokenizeToStringArray((String)locationsProperty, (String)","));
        } else if (this.locations != null) {
            flyway.setLocations(this.locations);
        }
        String basePackageValue = this.useValueIfPropertyNotSet(this.basePackage, "basePackage");
        if (basePackageValue != null) {
            flyway.setBasePackage(basePackageValue);
        }
        if ((baseDirValue = this.useValueIfPropertyNotSet(this.baseDir, "baseDir")) != null) {
            flyway.setBaseDir(baseDirValue);
        }
        if ((encodingValue = this.useValueIfPropertyNotSet(this.encoding, "encoding")) != null) {
            flyway.setEncoding(encodingValue);
        }
        if ((sqlMigrationPrefixValue = this.useValueIfPropertyNotSet(this.sqlMigrationPrefix, "sqlMigrationPrefix")) != null) {
            flyway.setSqlMigrationPrefix(sqlMigrationPrefixValue);
        }
        if ((sqlMigrationSuffixValue = this.useValueIfPropertyNotSet(this.sqlMigrationSuffix, "sqlMigrationSuffix")) != null) {
            flyway.setSqlMigrationSuffix(sqlMigrationSuffixValue);
        }
        if ((validationErrorModeValue = this.useValueIfPropertyNotSet(this.validationErrorMode, "validationErrorMode")) != null) {
            flyway.setValidationErrorMode(ValidationErrorMode.valueOf((String)validationErrorModeValue.toUpperCase()));
        }
        flyway.setCleanOnValidationError(this.useValueIfPropertyNotSet(this.cleanOnValidationError, "cleanOnValidationError"));
        flyway.setOutOfOrder(this.useValueIfPropertyNotSet(this.outOfOrder, "outOfOrder"));
        String targetValue = this.useValueIfPropertyNotSet(this.target, "target");
        if (targetValue != null) {
            flyway.setTarget(new MigrationVersion(targetValue));
        }
        AbstractMigrationLoadingTask.addPlaceholdersFromProperties(this.placeholders, this.getProject().getProperties());
        flyway.setPlaceholders(this.placeholders);
        String placeholderPrefixValue = this.useValueIfPropertyNotSet(this.placeholderPrefix, "placeholderPrefix");
        if (placeholderPrefixValue != null) {
            flyway.setPlaceholderPrefix(placeholderPrefixValue);
        }
        if ((placeholderSuffixValue = this.useValueIfPropertyNotSet(this.placeholderSuffix, "placeholderSuffix")) != null) {
            flyway.setPlaceholderSuffix(placeholderSuffixValue);
        }
        this.doExecuteWithMigrationConfig(flyway);
    }

    private static void addPlaceholdersFromProperties(Map<String, String> placeholders, Hashtable properties) {
        for (Object property : properties.keySet()) {
            String propertyName = (String)property;
            if (!propertyName.startsWith(PLACEHOLDERS_PROPERTY_PREFIX) || propertyName.length() <= PLACEHOLDERS_PROPERTY_PREFIX.length()) continue;
            String placeholderName = propertyName.substring(PLACEHOLDERS_PROPERTY_PREFIX.length());
            String placeholderValue = (String)properties.get(propertyName);
            placeholders.put(placeholderName, placeholderValue);
        }
    }

    protected abstract void doExecuteWithMigrationConfig(Flyway var1) throws Exception;

    public static class PlaceholderElement {
        private String name;
        private String value;

        public void setName(String name) {
            this.name = name;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }

    public static class PlaceholdersElement {
        Map<String, String> placeholders = new HashMap<String, String>();

        public void addConfiguredPlaceholder(PlaceholderElement placeholder) {
            this.placeholders.put(placeholder.name, placeholder.value);
        }
    }

    public static class LocationElement {
        private String path;

        public void setPath(String path) {
            this.path = path;
        }
    }

    public static class Locations {
        List<String> locations = new ArrayList<String>();

        public void addConfiguredLocation(LocationElement location) {
            this.locations.add(location.path);
        }
    }
}

