/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.postgresql;

import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.util.StringUtils;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PostgreSQLSqlStatementBuilder
extends SqlStatementBuilder {
    static final String DOLLAR_QUOTE_REGEX = "\\$[A-Za-z0-9_]*\\$.*";
    private boolean insideQuoteStringLiteral = false;
    private boolean insideDollarStringLiteral = false;
    private String dollarQuote = null;

    @Override
    protected boolean endsWithOpenMultilineStringLiteral(String line) {
        String[] tokens = StringUtils.tokenizeToStringArray(line, " ;=|(),");
        List<Set<TokenType>> delimitingTokens = this.extractStringLiteralDelimitingTokens(tokens);
        for (Set<TokenType> delimitingToken : delimitingTokens) {
            if (!this.insideDollarStringLiteral && !this.insideQuoteStringLiteral && delimitingToken.contains((Object)TokenType.QUOTE_OPEN)) {
                this.insideQuoteStringLiteral = true;
                continue;
            }
            if (this.insideQuoteStringLiteral && delimitingToken.contains((Object)TokenType.QUOTE_CLOSE)) {
                this.insideQuoteStringLiteral = false;
                continue;
            }
            if (!this.insideDollarStringLiteral && !this.insideQuoteStringLiteral && delimitingToken.contains((Object)TokenType.DOLLAR_OPEN)) {
                this.insideDollarStringLiteral = true;
                continue;
            }
            if (!this.insideDollarStringLiteral || !delimitingToken.contains((Object)TokenType.DOLLAR_CLOSE)) continue;
            this.insideDollarStringLiteral = false;
        }
        return this.insideQuoteStringLiteral || this.insideDollarStringLiteral;
    }

    private List<Set<TokenType>> extractStringLiteralDelimitingTokens(String[] tokens) {
        ArrayList<Set<TokenType>> delimitingTokens = new ArrayList<Set<TokenType>>();
        for (String token : tokens) {
            String cleanToken = StringUtils.replace(token, "''", "");
            HashSet<TokenType> tokenTypes = new HashSet<TokenType>();
            if (cleanToken.startsWith("'")) {
                if (cleanToken.length() > 1 && cleanToken.endsWith("'")) continue;
                tokenTypes.add(TokenType.QUOTE_OPEN);
            }
            if (cleanToken.endsWith("'")) {
                tokenTypes.add(TokenType.QUOTE_CLOSE);
            }
            if (this.dollarQuote == null && cleanToken.matches(DOLLAR_QUOTE_REGEX)) {
                this.dollarQuote = cleanToken.substring(0, cleanToken.substring(1).indexOf("$") + 2);
                if (cleanToken.length() > this.dollarQuote.length() && cleanToken.endsWith(this.dollarQuote)) {
                    this.dollarQuote = null;
                    continue;
                }
                tokenTypes.add(TokenType.DOLLAR_OPEN);
            }
            if (this.dollarQuote != null && !cleanToken.startsWith(this.dollarQuote) && cleanToken.endsWith(this.dollarQuote)) {
                tokenTypes.add(TokenType.DOLLAR_CLOSE);
                this.dollarQuote = null;
            }
            if (tokenTypes.isEmpty()) continue;
            delimitingTokens.add(tokenTypes);
        }
        return delimitingTokens;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TokenType {
        QUOTE_OPEN,
        QUOTE_CLOSE,
        DOLLAR_OPEN,
        DOLLAR_CLOSE;

    }
}

