/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport;

import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.SqlScript;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import java.sql.SQLException;

public abstract class DbSupport {
    protected final JdbcTemplate jdbcTemplate;

    public DbSupport(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    public JdbcTemplate getJdbcTemplate() {
        return this.jdbcTemplate;
    }

    public abstract SqlStatementBuilder createSqlStatementBuilder();

    public abstract SqlScript createCleanScript(String var1) throws SQLException;

    public abstract String getScriptLocation();

    public abstract boolean isSchemaEmpty(String var1) throws SQLException;

    public abstract boolean tableExistsNoQuotes(String var1, String var2) throws SQLException;

    public abstract boolean tableExists(String var1, String var2) throws SQLException;

    public abstract boolean primaryKeyExists(String var1, String var2) throws SQLException;

    public abstract boolean columnExists(String var1, String var2, String var3) throws SQLException;

    public abstract String getCurrentSchema() throws SQLException;

    public abstract void setCurrentSchema(String var1) throws SQLException;

    public abstract String getCurrentUserFunction();

    public abstract boolean supportsDdlTransactions();

    public abstract void lockTable(String var1, String var2) throws SQLException;

    public abstract String getBooleanTrue();

    public abstract String getBooleanFalse();

    public String quote(String ... identifiers) {
        String result = "";
        boolean first = true;
        for (String identifier : identifiers) {
            if (!first) {
                result = result + ".";
            }
            first = false;
            result = result + this.doQuote(identifier);
        }
        return result;
    }

    protected abstract String doQuote(String var1);
}

