/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.hsql;

import com.googlecode.flyway.core.dbsupport.Delimiter;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.util.StringUtils;

public class HsqlSqlStatementBuilder
extends SqlStatementBuilder {
    private int numQuotes;
    private boolean insideAtomicBlock;

    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        if (line.contains("BEGIN ATOMIC")) {
            this.insideAtomicBlock = true;
        }
        if (line.endsWith("END;")) {
            this.insideAtomicBlock = false;
        }
        if (this.insideAtomicBlock) {
            return null;
        }
        return this.getDefaultDelimiter();
    }

    protected boolean endsWithOpenMultilineStringLiteral(String line) {
        this.numQuotes += StringUtils.countOccurrencesOf(line, "'");
        return this.numQuotes % 2 != 0;
    }
}

