/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.resolver.jdbc;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.api.MigrationType;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.api.migration.MigrationChecksumProvider;
import com.googlecode.flyway.core.api.migration.MigrationInfoProvider;
import com.googlecode.flyway.core.api.migration.jdbc.JdbcMigration;
import com.googlecode.flyway.core.resolver.MigrationInfoHelper;
import com.googlecode.flyway.core.resolver.MigrationResolver;
import com.googlecode.flyway.core.resolver.ResolvedMigration;
import com.googlecode.flyway.core.resolver.jdbc.JdbcMigrationExecutor;
import com.googlecode.flyway.core.util.ClassUtils;
import com.googlecode.flyway.core.util.Pair;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.scanner.ClassPathScanner;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JdbcMigrationResolver
implements MigrationResolver {
    private final String basePackage;

    public JdbcMigrationResolver(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public List<ResolvedMigration> resolveMigrations() {
        ArrayList<ResolvedMigration> migrations = new ArrayList<ResolvedMigration>();
        try {
            Class<?>[] classes;
            for (Class<?> clazz : classes = new ClassPathScanner().scanForClasses(this.basePackage, JdbcMigration.class)) {
                JdbcMigration jdbcMigration = (JdbcMigration)ClassUtils.instantiate(clazz.getName());
                ResolvedMigration migrationInfo = this.extractMigrationInfo(jdbcMigration);
                migrationInfo.setPhysicalLocation(ClassUtils.getLocationOnDisk(clazz));
                migrationInfo.setExecutor(new JdbcMigrationExecutor(jdbcMigration));
                migrations.add(migrationInfo);
            }
        }
        catch (Exception e) {
            throw new FlywayException("Unable to resolve Jdbc Java migrations in location: " + this.basePackage, e);
        }
        Collections.sort(migrations);
        return migrations;
    }

    ResolvedMigration extractMigrationInfo(JdbcMigration jdbcMigration) {
        String description;
        MigrationVersion version;
        Integer checksum = null;
        if (jdbcMigration instanceof MigrationChecksumProvider) {
            MigrationChecksumProvider checksumProvider = (MigrationChecksumProvider)((Object)jdbcMigration);
            checksum = checksumProvider.getChecksum();
        }
        if (jdbcMigration instanceof MigrationInfoProvider) {
            MigrationInfoProvider infoProvider = (MigrationInfoProvider)((Object)jdbcMigration);
            version = infoProvider.getVersion();
            description = infoProvider.getDescription();
            if (!StringUtils.hasText(description)) {
                throw new FlywayException("Missing description for migration " + version);
            }
        } else {
            Pair<MigrationVersion, String> info = MigrationInfoHelper.extractVersionAndDescription(ClassUtils.getShortName(jdbcMigration.getClass()), "V", "");
            version = info.getLeft();
            description = info.getRight();
        }
        String script = jdbcMigration.getClass().getName();
        ResolvedMigration resolvedMigration = new ResolvedMigration();
        resolvedMigration.setVersion(version);
        resolvedMigration.setDescription(description);
        resolvedMigration.setScript(script);
        resolvedMigration.setChecksum(checksum);
        resolvedMigration.setType(MigrationType.JDBC);
        return resolvedMigration;
    }
}

