/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.info;

import com.googlecode.flyway.core.api.MigrationInfo;
import com.googlecode.flyway.core.util.DateUtils;
import com.googlecode.flyway.core.util.StringUtils;

public class MigrationInfoDumper {
    private MigrationInfoDumper() {
    }

    public static String dumpToAsciiTable(MigrationInfo[] migrationInfos) {
        StringBuilder table = new StringBuilder();
        table.append("+----------------+----------------------------+---------------------+---------+\n");
        table.append("| Version        | Description                | Installed on        | State   |\n");
        table.append("+----------------+----------------------------+---------------------+---------+\n");
        if (migrationInfos.length == 0) {
            table.append("| No migrations found                                                         |\n");
        } else {
            for (MigrationInfo migrationInfo : migrationInfos) {
                table.append("| ").append(StringUtils.trimOrPad(migrationInfo.getVersion().toString(), 14));
                table.append(" | ").append(StringUtils.trimOrPad(migrationInfo.getDescription(), 26));
                table.append(" | ").append(StringUtils.trimOrPad(DateUtils.formatDateAsIsoString(migrationInfo.getInstalledOn()), 19));
                table.append(" | ").append(StringUtils.trimOrPad(migrationInfo.getState().getDisplayName(), 7));
                table.append(" |\n");
            }
        }
        table.append("+----------------+----------------------------+---------------------+---------+");
        return table.toString();
    }
}

