/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.hsql;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.SqlScript;
import com.googlecode.flyway.core.dbsupport.SqlStatement;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.dbsupport.hsql.HsqlJdbcTemplate;
import com.googlecode.flyway.core.dbsupport.hsql.HsqlSqlStatementBuilder;
import com.googlecode.flyway.core.util.jdbc.JdbcUtils;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HsqlDbSupport
extends DbSupport {
    private static final Log LOG = LogFactory.getLog(HsqlDbSupport.class);
    private boolean version18;

    public HsqlDbSupport(Connection connection) {
        super(new HsqlJdbcTemplate(connection));
        try {
            int majorVersion = this.jdbcTemplate.getMetaData().getDatabaseMajorVersion();
            this.version18 = majorVersion < 2;
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to determine the Hsql version", e);
        }
        if (this.version18) {
            LOG.info("Hsql 1.8 does not support locking. No concurrent migration supported.");
        }
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/hsql/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "USER()";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCurrentSchema() throws SQLException {
        ResultSet resultSet = null;
        String schema = null;
        try {
            resultSet = this.jdbcTemplate.getMetaData().getSchemas();
            while (resultSet.next()) {
                if (!resultSet.getBoolean("IS_DEFAULT")) continue;
                schema = resultSet.getString("TABLE_SCHEM");
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        return schema;
    }

    @Override
    public void setCurrentSchema(String schema) throws SQLException {
        this.jdbcTemplate.execute("SET SCHEMA " + this.quote(schema), new Object[0]);
    }

    @Override
    public boolean isSchemaEmpty(String schema) throws SQLException {
        return !this.jdbcTemplate.tableExists(null, schema.toUpperCase(), null, new String[0]);
    }

    @Override
    public boolean tableExistsNoQuotes(String schema, String table) throws SQLException {
        return this.jdbcTemplate.tableExists(null, schema.toUpperCase(), table.toUpperCase(), new String[0]);
    }

    @Override
    public boolean tableExists(String schema, String table) throws SQLException {
        return this.jdbcTemplate.tableExists(null, schema, table, new String[0]);
    }

    @Override
    public boolean columnExists(String schema, String table, String column) throws SQLException {
        return this.jdbcTemplate.columnExists(null, schema, table, column);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public void lockTable(String schema, String table) throws SQLException {
        if (!this.version18) {
            this.jdbcTemplate.execute("select * from " + this.quote(schema) + "." + this.quote(table) + " for update", new Object[0]);
        }
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new HsqlSqlStatementBuilder();
    }

    @Override
    public SqlScript createCleanScript(String schema) throws SQLException {
        List<String> statements = this.generateDropStatementsForTables(schema);
        statements.addAll(this.generateDropStatementsForSequences(schema));
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int lineNumber = 1;
        for (String statement : statements) {
            sqlStatements.add(new SqlStatement(lineNumber, statement));
            ++lineNumber;
        }
        return new SqlScript(sqlStatements, (DbSupport)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> generateDropStatementsForTables(String schema) throws SQLException {
        ArrayList<String> statements = new ArrayList<String>();
        ResultSet resultSet = null;
        try {
            resultSet = this.jdbcTemplate.getMetaData().getTables(null, schema, null, new String[]{"TABLE"});
            while (resultSet.next()) {
                statements.add("DROP TABLE \"" + schema + "\".\"" + resultSet.getString("TABLE_NAME") + "\" CASCADE");
            }
        }
        catch (Throwable throwable) {
            JdbcUtils.closeResultSet(resultSet);
            throw throwable;
        }
        JdbcUtils.closeResultSet(resultSet);
        return statements;
    }

    private List<String> generateDropStatementsForSequences(String schema) throws SQLException {
        List<String> sequenceNames = this.jdbcTemplate.queryForStringList("SELECT SEQUENCE_NAME FROM INFORMATION_SCHEMA.SYSTEM_SEQUENCES where SEQUENCE_SCHEMA = ?", schema);
        ArrayList<String> statements = new ArrayList<String>();
        for (String seqName : sequenceNames) {
            statements.add("DROP SEQUENCE \"" + schema + "\".\"" + seqName + "\"");
        }
        return statements;
    }

    @Override
    public String doQuote(String identifier) {
        return "\"" + identifier + "\"";
    }
}

