/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.mysql;

import com.googlecode.flyway.core.dbsupport.Delimiter;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.util.StringUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MySQLSqlStatementBuilder
extends SqlStatementBuilder {
    private static final String DELIMITER_KEYWORD = "DELIMITER";
    private boolean insideQuoteStringLiteral = false;
    private boolean insideDoubleQuoteStringLiteral = false;

    @Override
    public Delimiter extractNewDelimiterFromLine(String line) {
        if (line.toUpperCase().startsWith(DELIMITER_KEYWORD)) {
            return new Delimiter(line.substring(DELIMITER_KEYWORD.length()).trim(), false);
        }
        return null;
    }

    @Override
    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        if (line.toUpperCase().startsWith(DELIMITER_KEYWORD)) {
            return new Delimiter(line.substring(DELIMITER_KEYWORD.length()).trim(), false);
        }
        return delimiter;
    }

    @Override
    public boolean isCommentDirective(String line) {
        return line.startsWith("/*!") && line.endsWith("*/;");
    }

    @Override
    public boolean isSingleLineComment(String line) {
        return super.isSingleLineComment(line) || line.startsWith("#");
    }

    @Override
    protected boolean endsWithOpenMultilineStringLiteral(String line) {
        String[] tokens = StringUtils.tokenizeToStringArray(line, " ;=|(),");
        List<Token> delimitingTokens = this.extractStringLiteralDelimitingTokens(tokens);
        for (Token delimitingToken : delimitingTokens) {
            boolean moreTokensApplicable = true;
            for (TokenType tokenType : delimitingToken.tokenTypes) {
                if (!moreTokensApplicable) continue;
                if (!this.insideDoubleQuoteStringLiteral && !this.insideQuoteStringLiteral && tokenType == TokenType.SINGLE_OPEN) {
                    this.insideQuoteStringLiteral = true;
                    if (!delimitingToken.singleTypeApplicable) continue;
                    moreTokensApplicable = false;
                    continue;
                }
                if (this.insideQuoteStringLiteral && tokenType == TokenType.SINGLE_CLOSE) {
                    this.insideQuoteStringLiteral = false;
                    moreTokensApplicable = false;
                    continue;
                }
                if (!this.insideDoubleQuoteStringLiteral && !this.insideQuoteStringLiteral && tokenType == TokenType.DOUBLE_OPEN) {
                    this.insideDoubleQuoteStringLiteral = true;
                    continue;
                }
                if (!this.insideDoubleQuoteStringLiteral || tokenType != TokenType.DOUBLE_CLOSE) continue;
                this.insideDoubleQuoteStringLiteral = false;
                moreTokensApplicable = false;
            }
        }
        return this.insideQuoteStringLiteral || this.insideDoubleQuoteStringLiteral;
    }

    private List<Token> extractStringLiteralDelimitingTokens(String[] tokens) {
        ArrayList<Token> delimitingTokens = new ArrayList<Token>();
        for (String token : tokens) {
            String cleanToken = StringUtils.replace(token, "''", "");
            ArrayList<TokenType> tokenTypes = new ArrayList<TokenType>();
            if (cleanToken.startsWith("'")) {
                tokenTypes.add(TokenType.SINGLE_OPEN);
            }
            if (cleanToken.endsWith("'")) {
                tokenTypes.add(TokenType.SINGLE_CLOSE);
            }
            if (cleanToken.startsWith("\"")) {
                tokenTypes.add(TokenType.DOUBLE_OPEN);
            }
            if (cleanToken.endsWith("\"")) {
                tokenTypes.add(TokenType.DOUBLE_CLOSE);
            }
            if (tokenTypes.isEmpty()) continue;
            Token parsedToken = new Token();
            parsedToken.tokenTypes = tokenTypes;
            parsedToken.singleTypeApplicable = token.length() == 1;
            delimitingTokens.add(parsedToken);
        }
        return delimitingTokens;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TokenType {
        SINGLE_OPEN,
        SINGLE_CLOSE,
        DOUBLE_OPEN,
        DOUBLE_CLOSE;

    }

    private class Token {
        public List<TokenType> tokenTypes;
        public boolean singleTypeApplicable;

        private Token() {
        }
    }
}

