/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.derby;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.Schema;
import com.googlecode.flyway.core.dbsupport.Table;
import java.sql.SQLException;

public class DerbyTable
extends Table {
    public DerbyTable(JdbcTemplate jdbcTemplate, DbSupport dbSupport, Schema schema, String name) {
        super(jdbcTemplate, dbSupport, schema, name);
    }

    protected void doDrop() throws SQLException {
        this.jdbcTemplate.execute("DROP TABLE " + this.dbSupport.quote(this.schema.getName(), this.name), new Object[0]);
    }

    protected boolean doExists() throws SQLException {
        return this.exists(null, this.schema, this.name, new String[0]);
    }

    protected boolean doExistsNoQuotes() throws SQLException {
        return this.exists(null, this.dbSupport.getSchema(this.schema.getName().toUpperCase()), this.name.toUpperCase(), new String[0]);
    }

    protected void doLock() throws SQLException {
        this.jdbcTemplate.execute("LOCK TABLE " + this + " IN EXCLUSIVE MODE", new Object[0]);
    }
}

