/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.api;

import com.googlecode.flyway.core.api.FlywayException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MigrationVersion
implements Comparable<MigrationVersion> {
    public static final MigrationVersion EMPTY = new MigrationVersion(null, "<< Empty Schema >>");
    public static final MigrationVersion LATEST = new MigrationVersion(Long.toString(Long.MAX_VALUE), "<< Latest Version >>");
    private final String version;
    private final String displayText;

    public MigrationVersion(String version) {
        String normalizedVersion = version.replace("_", ".");
        if (normalizedVersion.startsWith(".")) {
            throw new FlywayException("Invalid version starting with a dot (.) instead of a digit: " + normalizedVersion);
        }
        if (!normalizedVersion.matches("[\\d\\.]*")) {
            throw new FlywayException("Invalid version containing non-numeric characters. Only 0..9 and . are allowed. Invalid version: " + normalizedVersion);
        }
        this.version = normalizedVersion;
        this.displayText = normalizedVersion;
    }

    private MigrationVersion(String version, String displayText) {
        this.version = version;
        this.displayText = displayText;
    }

    private String[] getElements() {
        return this.tokenizeToStringArray(this.version, ".");
    }

    public String toString() {
        return this.displayText;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationVersion version1 = (MigrationVersion)o;
        return this.compareTo(version1) == 0;
    }

    public int hashCode() {
        int result = this.version != null ? this.version.hashCode() : 0;
        result = 31 * result + this.displayText.hashCode();
        return result;
    }

    @Override
    public int compareTo(MigrationVersion o) {
        if (o == null) {
            return 1;
        }
        if (this == EMPTY) {
            return Integer.MIN_VALUE;
        }
        if (this == LATEST) {
            return Integer.MAX_VALUE;
        }
        if (o == EMPTY) {
            return Integer.MAX_VALUE;
        }
        if (o == LATEST) {
            return Integer.MIN_VALUE;
        }
        String[] elements1 = this.getElements();
        String[] elements2 = o.getElements();
        int smallestNumberOfElements = Math.min(elements1.length, elements2.length);
        for (int i = 0; i < smallestNumberOfElements; ++i) {
            String element1 = elements1[i];
            String element2 = elements2[i];
            int compared = this.isNumeric(element1) && this.isNumeric(element2) ? Long.valueOf(element1).compareTo(Long.valueOf(element2)) : element1.compareTo(element2);
            if (compared == 0) continue;
            return compared;
        }
        int lengthDifference = elements1.length - elements2.length;
        if (lengthDifference > 0 && this.onlyTrailingZeroes(elements1, smallestNumberOfElements)) {
            return 0;
        }
        if (lengthDifference < 0 && this.onlyTrailingZeroes(elements2, smallestNumberOfElements)) {
            return 0;
        }
        return lengthDifference;
    }

    private boolean onlyTrailingZeroes(String[] elements, int position) {
        for (int i = position; i < elements.length; ++i) {
            String element = elements[i];
            if (this.isNumeric(element) && Long.valueOf(element).equals(0L)) continue;
            return false;
        }
        return true;
    }

    private String[] tokenizeToStringArray(String str, String delimiters) {
        if (str == null) {
            return null;
        }
        String[] tokens = str.split("[" + delimiters + "]");
        for (int i = 0; i < tokens.length; ++i) {
            tokens[i] = tokens[i].trim();
        }
        return tokens;
    }

    private boolean isNumeric(String str) {
        if (str == null) {
            return false;
        }
        return str.matches("\\d*");
    }
}

