/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.ant;

import com.googlecode.flyway.ant.AntLogCreator;
import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.util.ExceptionUtils;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.jdbc.DriverDataSource;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogCreator;
import com.googlecode.flyway.core.util.logging.LogFactory;
import javax.sql.DataSource;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public abstract class AbstractFlywayTask
extends Task {
    protected Log log;
    private Path classPath;
    private String driver;
    private String url;
    private String user;
    private String password;
    private String schemas;
    private String table;
    @Deprecated
    private String initialVersion;
    @Deprecated
    private String initialDescription;
    private String initVersion;
    private String initDescription;

    public void setClasspath(Path classpath) {
        this.classPath = classpath;
    }

    public void setClasspathref(Reference classpathref) {
        Path classPath = new Path(this.getProject());
        classPath.setRefid(classpathref);
        this.classPath = classPath;
    }

    public void setDriver(String driver) {
        this.driver = driver;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setSchemas(String schemas) {
        this.schemas = schemas;
    }

    public void setTable(String table) {
        this.table = table;
    }

    @Deprecated
    public void setInitialVersion(String initialVersion) {
        this.initialVersion = initialVersion;
    }

    @Deprecated
    public void setInitialDescription(String initialDescription) {
        this.initialDescription = initialDescription;
    }

    public void setInitVersion(String initVersion) {
        this.initVersion = initVersion;
    }

    public void setInitDescription(String initDescription) {
        this.initDescription = initDescription;
    }

    DataSource createDataSource() throws Exception {
        String driverValue = this.useValueIfPropertyNotSet(this.driver, "driver");
        String urlValue = this.useValueIfPropertyNotSet(this.url, "url");
        String userValue = this.useValueIfPropertyNotSet(this.user, "user");
        String passwordValue = this.useValueIfPropertyNotSet(this.password, "password");
        return new DriverDataSource(driverValue, urlValue, userValue, passwordValue, new String[0]);
    }

    protected String useValueIfPropertyNotSet(String value, String flywayProperty) {
        String propertyValue = this.getProject().getProperty("flyway." + flywayProperty);
        if (propertyValue != null) {
            return propertyValue;
        }
        return value;
    }

    protected boolean useValueIfPropertyNotSet(boolean value, String flywayProperty) {
        String propertyValue = this.getProject().getProperty("flyway." + flywayProperty);
        if (propertyValue != null) {
            return Boolean.parseBoolean(propertyValue);
        }
        return value;
    }

    private void prepareClassPath() {
        Path classpath = (Path)this.getProject().getReference("flyway.classpath");
        if (classpath != null) {
            this.setClasspath(classpath);
        } else {
            Reference classpathRef = (Reference)this.getProject().getReference("flyway.classpathref");
            if (classpathRef != null) {
                this.setClasspathref(classpathRef);
            }
        }
        AntClassLoader classLoader = new AntClassLoader(((Object)((Object)this)).getClass().getClassLoader(), this.getProject(), this.classPath);
        Thread.currentThread().setContextClassLoader((ClassLoader)classLoader);
    }

    public void execute() throws BuildException {
        LogFactory.setLogCreator((LogCreator)new AntLogCreator(this.getProject()));
        this.log = LogFactory.getLog(((Object)((Object)this)).getClass());
        this.prepareClassPath();
        try {
            String initDescriptionValue;
            String initVersionValue;
            String initialDescriptionValue;
            String initialVersionValue;
            String tableValue;
            Flyway flyway = new Flyway();
            flyway.setDataSource(this.createDataSource());
            String schemasValue = this.useValueIfPropertyNotSet(this.schemas, "schemas");
            if (schemasValue != null) {
                flyway.setSchemas(StringUtils.tokenizeToStringArray((String)schemasValue, (String)","));
            }
            if ((tableValue = this.useValueIfPropertyNotSet(this.table, "table")) != null) {
                flyway.setTable(tableValue);
            }
            if ((initialVersionValue = this.useValueIfPropertyNotSet(this.initialVersion, "initialVersion")) != null) {
                flyway.setInitialVersion(initialVersionValue);
            }
            if ((initialDescriptionValue = this.useValueIfPropertyNotSet(this.initialDescription, "initialDescription")) != null) {
                flyway.setInitialDescription(initialDescriptionValue);
            }
            if ((initVersionValue = this.useValueIfPropertyNotSet(this.initVersion, "initVersion")) != null) {
                flyway.setInitVersion(initVersionValue);
            }
            if ((initDescriptionValue = this.useValueIfPropertyNotSet(this.initDescription, "initDescription")) != null) {
                flyway.setInitDescription(initDescriptionValue);
            }
            this.doExecute(flyway);
        }
        catch (Exception e) {
            this.log.error(e.toString());
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause != null) {
                this.log.error("Caused by " + rootCause.toString());
            }
            throw new BuildException("Flyway Error: " + e.toString(), (Throwable)e);
        }
    }

    protected abstract void doExecute(Flyway var1) throws Exception;
}

