/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.command;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.api.MigrationInfo;
import com.googlecode.flyway.core.api.MigrationState;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.Schema;
import com.googlecode.flyway.core.info.MigrationInfoImpl;
import com.googlecode.flyway.core.info.MigrationInfoServiceImpl;
import com.googlecode.flyway.core.metadatatable.AppliedMigration;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.resolver.MigrationResolver;
import com.googlecode.flyway.core.resolver.ResolvedMigration;
import com.googlecode.flyway.core.util.ExceptionUtils;
import com.googlecode.flyway.core.util.Pair;
import com.googlecode.flyway.core.util.StopWatch;
import com.googlecode.flyway.core.util.TimeFormat;
import com.googlecode.flyway.core.util.jdbc.TransactionCallback;
import com.googlecode.flyway.core.util.jdbc.TransactionTemplate;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.Connection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DbMigrate {
    private static final Log LOG = LogFactory.getLog(DbMigrate.class);
    private final MigrationVersion target;
    private final DbSupport dbSupport;
    private final MetaDataTable metaDataTable;
    private final Schema schema;
    private final MigrationResolver migrationResolver;
    private final Connection connectionMetaDataTable;
    private final Connection connectionUserObjects;
    private final boolean ignoreFailedFutureMigration;
    private boolean outOfOrder;

    public DbMigrate(Connection connectionMetaDataTable, Connection connectionUserObjects, DbSupport dbSupport, MetaDataTable metaDataTable, Schema schema, MigrationResolver migrationResolver, MigrationVersion target, boolean ignoreFailedFutureMigration, boolean outOfOrder) {
        this.connectionMetaDataTable = connectionMetaDataTable;
        this.connectionUserObjects = connectionUserObjects;
        this.dbSupport = dbSupport;
        this.metaDataTable = metaDataTable;
        this.schema = schema;
        this.migrationResolver = migrationResolver;
        this.target = target;
        this.ignoreFailedFutureMigration = ignoreFailedFutureMigration;
        this.outOfOrder = outOfOrder;
    }

    public int migrate() throws FlywayException {
        boolean firstRun;
        Pair<Boolean, MigrationVersion> result;
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        int migrationSuccessCount = 0;
        while ((result = new TransactionTemplate(this.connectionMetaDataTable).execute(new TransactionCallback<Pair<Boolean, MigrationVersion>>(firstRun = migrationSuccessCount == 0){
            final /* synthetic */ boolean val$firstRun;
            {
                this.val$firstRun = bl;
            }

            @Override
            public Pair<Boolean, MigrationVersion> doInTransaction() {
                MigrationInfoImpl[] pendingMigrations;
                MigrationInfo[] failed;
                boolean isFutureMigration;
                DbMigrate.this.metaDataTable.lock();
                MigrationInfoServiceImpl infoService = new MigrationInfoServiceImpl(DbMigrate.this.migrationResolver, DbMigrate.this.metaDataTable, DbMigrate.this.target, DbMigrate.this.outOfOrder);
                infoService.refresh();
                MigrationVersion currentSchemaVersion = MigrationVersion.EMPTY;
                if (infoService.current() != null) {
                    currentSchemaVersion = infoService.current().getVersion();
                }
                if (this.val$firstRun) {
                    LOG.info("Current version of schema " + DbMigrate.this.schema + ": " + currentSchemaVersion);
                    if (DbMigrate.this.outOfOrder) {
                        LOG.warn("outOfOrder mode is active. Migration of schema " + DbMigrate.this.schema + " may not be reproducible.");
                    }
                }
                MigrationInfo[] future = infoService.future();
                MigrationInfo[] resolved = infoService.resolved();
                boolean bl = isFutureMigration = future.length < 0;
                if (isFutureMigration) {
                    LOG.warn("Schema " + DbMigrate.this.schema + " has a version (" + currentSchemaVersion + ") that is newer than the latest available migration (" + resolved[resolved.length - 1].getVersion() + ") !");
                }
                if ((failed = infoService.failed()).length > 0) {
                    if (failed.length == 1 && failed[0].getState() == MigrationState.FUTURE_FAILED && DbMigrate.this.ignoreFailedFutureMigration) {
                        LOG.warn("Schema " + DbMigrate.this.schema + " contains a failed future migration to version " + failed[0].getVersion() + " !");
                    } else {
                        return Pair.of(false, failed[0].getVersion());
                    }
                }
                if ((pendingMigrations = infoService.pending()).length == 0) {
                    return null;
                }
                boolean isOutOfOrder = pendingMigrations[0].getVersion().compareTo(currentSchemaVersion) < 0;
                return DbMigrate.this.applyMigration(pendingMigrations[0].getResolvedMigration(), isOutOfOrder);
            }
        })) != null) {
            if (!result.getLeft().booleanValue()) {
                throw new FlywayException("Migration of schema " + this.schema + " to version " + result.getRight() + " failed! Please restore backups and roll back database and code!");
            }
            ++migrationSuccessCount;
        }
        stopWatch.stop();
        this.logSummary(migrationSuccessCount, stopWatch.getTotalTimeMillis());
        return migrationSuccessCount;
    }

    private void logSummary(int migrationSuccessCount, long executionTime) {
        if (migrationSuccessCount == 0) {
            LOG.info("Schema " + this.schema + " is up to date. No migration necessary.");
            return;
        }
        if (migrationSuccessCount == 1) {
            LOG.info("Successfully applied 1 migration to schema " + this.schema + " (execution time " + TimeFormat.format(executionTime) + ").");
        } else {
            LOG.info("Successfully applied " + migrationSuccessCount + " migrations to schema " + this.schema + " (execution time " + TimeFormat.format(executionTime) + ").");
        }
    }

    private Pair<Boolean, MigrationVersion> applyMigration(final ResolvedMigration migration, boolean isOutOfOrder) throws FlywayException {
        boolean success;
        StopWatch stopWatch;
        MigrationVersion version;
        block5: {
            version = migration.getVersion();
            if (isOutOfOrder) {
                LOG.info("Migrating schema " + this.schema + " to version " + version + " (out of order)");
            } else {
                LOG.info("Migrating schema " + this.schema + " to version " + version);
            }
            stopWatch = new StopWatch();
            stopWatch.start();
            success = false;
            try {
                new TransactionTemplate(this.connectionUserObjects).execute(new TransactionCallback<Void>(){

                    @Override
                    public Void doInTransaction() {
                        migration.getExecutor().execute(new JdbcTemplate(DbMigrate.this.connectionUserObjects, 0), DbMigrate.this.dbSupport);
                        return null;
                    }
                });
                LOG.debug("Successfully completed and committed migration of schema " + this.schema + " to version " + version);
                success = true;
            }
            catch (Exception e) {
                LOG.error(e.toString());
                Throwable rootCause = ExceptionUtils.getRootCause(e);
                if (rootCause == null) break block5;
                LOG.error("Caused by " + rootCause.toString());
            }
        }
        stopWatch.stop();
        int executionTime = (int)stopWatch.getTotalTimeMillis();
        if (!success && this.dbSupport.supportsDdlTransactions()) {
            throw new FlywayException("Migration of schema " + this.schema + " to version " + version + " failed! Changes successfully rolled back.");
        }
        LOG.debug(String.format("Finished migrating schema %s to version %s (execution time %s)", this.schema, version, TimeFormat.format(executionTime)));
        AppliedMigration appliedMigration = new AppliedMigration(version, migration.getDescription(), migration.getType(), migration.getScript(), migration.getChecksum(), executionTime, success);
        this.metaDataTable.addAppliedMigration(appliedMigration);
        return Pair.of(success, migration.getVersion());
    }
}

