/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.command;

import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.info.MigrationInfoServiceImpl;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.resolver.MigrationResolver;
import com.googlecode.flyway.core.util.Pair;
import com.googlecode.flyway.core.util.StopWatch;
import com.googlecode.flyway.core.util.TimeFormat;
import com.googlecode.flyway.core.util.jdbc.TransactionCallback;
import com.googlecode.flyway.core.util.jdbc.TransactionTemplate;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.Connection;

public class DbValidate {
    private static final Log LOG = LogFactory.getLog(DbValidate.class);
    private final MigrationVersion target;
    private final MetaDataTable metaDataTable;
    private final MigrationResolver migrationResolver;
    private final Connection connectionMetaDataTable;
    private boolean outOfOrder;

    public DbValidate(Connection connectionMetaDataTable, MetaDataTable metaDataTable, MigrationResolver migrationResolver, MigrationVersion target, boolean outOfOrder) {
        this.connectionMetaDataTable = connectionMetaDataTable;
        this.metaDataTable = metaDataTable;
        this.migrationResolver = migrationResolver;
        this.target = target;
        this.outOfOrder = outOfOrder;
    }

    public String validate() {
        LOG.debug("Validating migrations ...");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Pair<Integer, String> result = new TransactionTemplate(this.connectionMetaDataTable).execute(new TransactionCallback<Pair<Integer, String>>(){

            @Override
            public Pair<Integer, String> doInTransaction() {
                MigrationInfoServiceImpl migrationInfoService = new MigrationInfoServiceImpl(DbValidate.this.migrationResolver, DbValidate.this.metaDataTable, DbValidate.this.target, DbValidate.this.outOfOrder);
                migrationInfoService.refresh();
                if (migrationInfoService.applied().length == 0) {
                    LOG.info("No migrations applied yet. No validation necessary.");
                    return Pair.of(0, null);
                }
                int count = migrationInfoService.all().length;
                String validationError = migrationInfoService.validate();
                return Pair.of(count, validationError);
            }
        });
        stopWatch.stop();
        int count = result.getLeft();
        if (count == 1) {
            LOG.info(String.format("Validated 1 migration (execution time %s)", TimeFormat.format(stopWatch.getTotalTimeMillis())));
        } else {
            LOG.info(String.format("Validated %d migrations (execution time %s)", count, TimeFormat.format(stopWatch.getTotalTimeMillis())));
        }
        return result.getRight();
    }
}

