/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util.logging;

import com.googlecode.flyway.core.util.FeatureDetector;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogCreator;
import com.googlecode.flyway.core.util.logging.apachecommons.ApacheCommonsLogCreator;
import com.googlecode.flyway.core.util.logging.javautil.JavaUtilLogCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LogFactory {
    private static LogCreator logCreator;

    private LogFactory() {
    }

    public static void setLogCreator(LogCreator logCreator) {
        LogFactory.logCreator = logCreator;
    }

    public static Log getLog(Class<?> clazz) {
        if (logCreator == null) {
            logCreator = FeatureDetector.isApacheCommonsLoggingAvailable() ? new ApacheCommonsLogCreator() : new JavaUtilLogCreator();
        }
        return logCreator.createLogger(clazz);
    }
}

