/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

public class ResourceUtils {
    private ResourceUtils() {
    }

    public static String loadResourceAsString(String location) {
        return ResourceUtils.loadResourceAsString((Resource)new ClassPathResource(location, ResourceUtils.class.getClassLoader()), "UTF-8");
    }

    public static String loadResourceAsString(Resource resource, String encoding) {
        try {
            InputStreamReader reader = new InputStreamReader(resource.getInputStream(), Charset.forName(encoding));
            return FileCopyUtils.copyToString((Reader)reader);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load resource: " + resource.getDescription() + " (encoding: " + encoding + ")", e);
        }
    }
}

