/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.db2;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.db2.DB2SqlScript;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.migration.sql.SqlStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class DB2DbSupport
implements DbSupport {
    private final JdbcTemplate jdbcTemplate;

    public DB2DbSupport(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        return new DB2SqlScript(sqlScriptSource, placeholderReplacer);
    }

    @Override
    public SqlScript createCleanScript() {
        ArrayList<String> allDropStatements = new ArrayList<String>();
        String currentSchema = this.getCurrentSchema();
        String dropViewsGenQuery = "select rtrim(VIEWNAME) from SYSCAT.VIEWS where VIEWSCHEMA = '" + currentSchema + "'";
        List<String> dropViewsStatements = this.buildDropStatements("drop view", dropViewsGenQuery);
        allDropStatements.addAll(dropViewsStatements);
        String dropTablesGenQuery = "select rtrim(TABNAME) from SYSCAT.TABLES where TABSCHEMA = '" + currentSchema + "'";
        List<String> dropTableStatements = this.buildDropStatements("drop table", dropTablesGenQuery);
        allDropStatements.addAll(dropTableStatements);
        String dropSeqGenQuery = "select rtrim(SEQNAME) from SYSCAT.SEQUENCES where SEQSCHEMA = '" + currentSchema + "'";
        List<String> dropSeqStatements = this.buildDropStatements("drop sequence", dropSeqGenQuery);
        allDropStatements.addAll(dropSeqStatements);
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int count = 0;
        for (String dropStatement : allDropStatements) {
            sqlStatements.add(new SqlStatement(++count, dropStatement));
        }
        return new SqlScript(sqlStatements);
    }

    private List<String> buildDropStatements(String dropPrefix, String query) {
        ArrayList<String> dropStatements = new ArrayList<String>();
        List dbObjects = this.jdbcTemplate.queryForList(query, String.class);
        for (String dbObject : dbObjects) {
            dropStatements.add(dropPrefix + " \"" + this.getCurrentSchema() + "\".\"" + dbObject + "\"");
        }
        return dropStatements;
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/db2/";
    }

    @Override
    public boolean isSchemaEmpty() {
        int objectCount = this.jdbcTemplate.queryForInt("select count(*) from syscat.tables where tabschema = CURRENT_SCHEMA");
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from syscat.views where viewschema = CURRENT_SCHEMA");
        objectCount += this.jdbcTemplate.queryForInt("select count(*) from syscat.sequences where seqschema = CURRENT_SCHEMA");
        return (objectCount += this.jdbcTemplate.queryForInt("select count(*) from syscat.indexes where indschema = CURRENT_SCHEMA")) == 0;
    }

    @Override
    public boolean tableExists(final String table) {
        return (Boolean)this.jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getTables(null, DB2DbSupport.this.getCurrentSchema(), table.toUpperCase(), null);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean columnExists(final String table, final String column) {
        return (Boolean)this.jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getColumns(null, DB2DbSupport.this.getCurrentSchema(), table.toUpperCase(), column.toUpperCase());
                return resultSet.next();
            }
        });
    }

    @Override
    public String getCurrentSchema() {
        return ((String)this.jdbcTemplate.queryForObject("select current_schema from sysibm.sysdummy1", String.class)).trim();
    }

    @Override
    public String getCurrentUserFunction() {
        return "CURRENT_USER";
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public void lockTable(String table) {
        this.jdbcTemplate.execute("lock table " + table + " in exclusive mode");
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }
}

