/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.sqlserver;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.sqlserver.SQLServerSqlScript;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.migration.sql.SqlStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class SQLServerDbSupport
implements DbSupport {
    private final JdbcTemplate jdbcTemplate;

    public SQLServerDbSupport(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/sqlserver/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "SUSER_NAME()";
    }

    @Override
    public String getCurrentSchema() {
        return (String)this.jdbcTemplate.execute(new ConnectionCallback(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                return connection.getCatalog();
            }
        });
    }

    @Override
    public boolean isSchemaEmpty() {
        int objectCount = this.jdbcTemplate.queryForInt("Select count(*) FROM ( Select TABLE_NAME as OBJECT_NAME, TABLE_SCHEMA as OBJECT_SCHEMA from information_schema.TABLES Union Select TABLE_NAME as OBJECT_NAME, TABLE_SCHEMA as OBJECT_SCHEMA from information_schema.VIEWS Union Select CONSTRAINT_NAME as OBJECT_NAME, TABLE_SCHEMA as OBJECT_SCHEMA from information_schema.TABLE_CONSTRAINTS Union Select ROUTINE_NAME as OBJECT_NAME, ROUTINE_SCHEMA as OBJECT_SCHEMA from information_schema.ROUTINES ) R ");
        return objectCount == 0;
    }

    @Override
    public boolean tableExists(final String table) {
        return (Boolean)this.jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getTables(SQLServerDbSupport.this.getCurrentSchema(), null, table, null);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean columnExists(final String table, final String column) {
        return (Boolean)this.jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getColumns(SQLServerDbSupport.this.getCurrentSchema(), null, table, column);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public void lockTable(String table) {
        this.jdbcTemplate.execute("select * from " + table + " WITH (TABLOCKX)");
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        return new SQLServerSqlScript(sqlScriptSource, placeholderReplacer);
    }

    @Override
    public SqlScript createCleanScript() {
        int lineNumber = 0;
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        lineNumber = this.cleanForeignKeys(this.jdbcTemplate, lineNumber, sqlStatements);
        lineNumber = this.cleanRoutines(this.jdbcTemplate, lineNumber, sqlStatements);
        lineNumber = this.cleanViews(this.jdbcTemplate, lineNumber, sqlStatements);
        this.cleanTables(this.jdbcTemplate, lineNumber, sqlStatements);
        return new SqlScript(sqlStatements);
    }

    private void cleanTables(JdbcTemplate jdbcTemplate, int lineNumber, List<SqlStatement> sqlStatements) {
        List tableNames = jdbcTemplate.queryForList("SELECT table_schema, table_name FROM information_schema.tables WHERE table_type='BASE TABLE'");
        ++lineNumber;
        for (Map row : tableNames) {
            String tableSchema = (String)row.get("table_schema");
            String tableName = (String)row.get("table_name");
            sqlStatements.add(new SqlStatement(++lineNumber, "DROP TABLE [" + tableSchema + "].[" + tableName + "]"));
        }
    }

    private int cleanForeignKeys(JdbcTemplate jdbcTemplate, int lineNumber, List<SqlStatement> sqlStatements) {
        List constraintNames = jdbcTemplate.queryForList("SELECT table_schema, table_name, constraint_name FROM information_schema.table_constraints WHERE constraint_type = 'FOREIGN KEY'");
        for (Map row : constraintNames) {
            String tableSchema = (String)row.get("table_schema");
            String tableName = (String)row.get("table_name");
            String constraintName = (String)row.get("constraint_name");
            sqlStatements.add(new SqlStatement(++lineNumber, "ALTER TABLE [" + tableSchema + "].[" + tableName + "] DROP CONSTRAINT [" + constraintName + "]"));
        }
        return lineNumber;
    }

    private int cleanRoutines(JdbcTemplate jdbcTemplate, int lineNumber, List<SqlStatement> sqlStatements) {
        List routineNames = jdbcTemplate.queryForList("SELECT routine_name, routine_type FROM information_schema.routines");
        for (Map row : routineNames) {
            String routineName = (String)row.get("routine_name");
            String routineType = (String)row.get("routine_type");
            sqlStatements.add(new SqlStatement(++lineNumber, "DROP " + routineType + " " + routineName));
        }
        return lineNumber;
    }

    private int cleanViews(JdbcTemplate jdbcTemplate, int lineNumber, List<SqlStatement> sqlStatements) {
        List viewNames = jdbcTemplate.queryForList("SELECT table_name FROM information_schema.views");
        for (Map row : viewNames) {
            String viewName = (String)row.get("table_name");
            sqlStatements.add(new SqlStatement(++lineNumber, "DROP VIEW " + viewName));
        }
        return lineNumber;
    }
}

