/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.oracle;

import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;

public class OracleSqlScript
extends SqlScript {
    private static final String PLSQL_DELIMITER = "/";

    public OracleSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        super(sqlScriptSource, placeholderReplacer);
    }

    @Override
    protected String changeDelimiterIfNecessary(String statement, String line, String delimiter) {
        String upperCaseLine = line.toUpperCase();
        if (upperCaseLine.matches("DECLARE|DECLARE\\s.*") || upperCaseLine.matches("BEGIN|BEGIN\\s.*")) {
            return PLSQL_DELIMITER;
        }
        if (upperCaseLine.startsWith("CREATE") && (upperCaseLine.contains("FUNCTION") || upperCaseLine.contains("PROCEDURE") || upperCaseLine.contains("PACKAGE"))) {
            return PLSQL_DELIMITER;
        }
        return delimiter;
    }
}

