/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.oracle;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.oracle.OracleSqlScript;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.migration.sql.SqlStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OracleDbSupport
implements DbSupport {
    private static final Log LOG = LogFactory.getLog(OracleDbSupport.class);
    private final JdbcTemplate jdbcTemplate;

    public OracleDbSupport(JdbcTemplate jdbcTemplate) {
        this.jdbcTemplate = jdbcTemplate;
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/oracle/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "USER";
    }

    @Override
    public String getCurrentSchema() {
        return (String)this.jdbcTemplate.execute(new ConnectionCallback(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                return connection.getMetaData().getUserName();
            }
        });
    }

    @Override
    public boolean isSchemaEmpty(String schema) {
        int objectCount = this.jdbcTemplate.queryForInt("SELECT count(*) FROM all_objects WHERE owner = ?", new Object[]{schema});
        return objectCount == 0;
    }

    @Override
    public boolean tableExists(final String schema, final String table) {
        return (Boolean)this.jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getTables(null, schema.toUpperCase(), table.toUpperCase(), null);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public void lockTable(String schema, String table) {
        this.jdbcTemplate.execute("select * from " + schema + "." + table + " for update");
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlScript createSqlScript(String sqlScriptSource, PlaceholderReplacer placeholderReplacer) {
        return new OracleSqlScript(sqlScriptSource, placeholderReplacer);
    }

    @Override
    public SqlScript createCleanScript(String schema) {
        if ("SYSTEM".equals(schema.toUpperCase())) {
            throw new FlywayException("Clean not supported on Oracle for user 'SYSTEM'! You should NEVER add your own objects to the SYSTEM schema!");
        }
        ArrayList<String> allDropStatements = new ArrayList<String>();
        allDropStatements.add("PURGE RECYCLEBIN");
        allDropStatements.addAll(this.generateDropStatementsForSpatialExtensions(schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("SEQUENCE", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("FUNCTION", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("MATERIALIZED VIEW", "PRESERVE TABLE", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("PACKAGE", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("PROCEDURE", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("SYNONYM", "", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("VIEW", "CASCADE CONSTRAINTS", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("TABLE", "CASCADE CONSTRAINTS PURGE", schema));
        allDropStatements.addAll(this.generateDropStatementsForObjectType("TYPE", "", schema));
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int lineNumber = 1;
        for (String dropStatement : allDropStatements) {
            sqlStatements.add(new SqlStatement(lineNumber, dropStatement));
            ++lineNumber;
        }
        return new SqlScript(sqlStatements);
    }

    private List<String> generateDropStatementsForObjectType(String objectType, final String extraArguments, final String schema) {
        String query = "SELECT object_type, object_name FROM all_objects WHERE object_type = ? AND owner = ? AND object_name NOT LIKE 'BIN$%' AND object_name NOT LIKE 'MDRT_%$' AND object_name NOT LIKE 'MDRS_%$' AND object_name NOT LIKE 'MLOG$%' AND object_name NOT LIKE 'RUPD$%'";
        return this.jdbcTemplate.query(query, new Object[]{objectType, schema.toUpperCase()}, new RowMapper(){

            public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                return "DROP " + rs.getString("OBJECT_TYPE") + " " + schema + ".\"" + rs.getString("OBJECT_NAME") + "\" " + extraArguments;
            }
        });
    }

    private List<String> generateDropStatementsForSpatialExtensions(String schema) {
        ArrayList<String> statements = new ArrayList<String>();
        if (!this.spatialExtensionsAvailable()) {
            LOG.debug((Object)"Oracle Spatial Extensions are not available. No cleaning of MDSYS tables and views.");
            return statements;
        }
        if (!this.getCurrentSchema().equalsIgnoreCase(schema)) {
            int count = this.jdbcTemplate.queryForInt("SELECT COUNT (*) FROM all_sdo_geom_metadata WHERE owner=?", new Object[]{schema.toUpperCase()});
            if ((count += this.jdbcTemplate.queryForInt("SELECT COUNT (*) FROM all_sdo_index_info WHERE sdo_index_owner=?", new Object[]{schema.toUpperCase()})) > 0) {
                LOG.warn((Object)("Unable to clean Oracle Spatial objects for schema '" + schema + "' as they do not belong to the default schema for this connection!"));
            }
            return statements;
        }
        statements.add("DELETE FROM mdsys.user_sdo_geom_metadata");
        List indexNames = this.jdbcTemplate.queryForList("select INDEX_NAME from USER_SDO_INDEX_INFO", String.class);
        for (String indexName : indexNames) {
            statements.add("DROP INDEX \"" + indexName + "\"");
        }
        return statements;
    }

    private boolean spatialExtensionsAvailable() {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM all_views WHERE owner = 'MDSYS' AND view_name = 'USER_SDO_GEOM_METADATA'") > 0;
    }
}

