/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.java;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.migration.Migration;
import com.googlecode.flyway.core.migration.MigrationInfoHelper;
import com.googlecode.flyway.core.migration.MigrationType;
import com.googlecode.flyway.core.migration.java.JavaMigration;
import com.googlecode.flyway.core.migration.java.JavaMigrationChecksumProvider;
import com.googlecode.flyway.core.migration.java.JavaMigrationInfoProvider;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.util.ClassUtils;

public class JavaMigrationExecutor
extends Migration {
    private final JavaMigration javaMigration;

    public JavaMigrationExecutor(JavaMigration javaMigration) {
        String nameWithoutV;
        JavaMigrationInfoProvider infoProvider;
        this.javaMigration = javaMigration;
        if (ClassUtils.isAssignableValue(JavaMigrationChecksumProvider.class, (Object)javaMigration)) {
            JavaMigrationChecksumProvider checksumProvider = (JavaMigrationChecksumProvider)((Object)javaMigration);
            this.checksum = checksumProvider.getChecksum();
        }
        if (ClassUtils.isAssignableValue(JavaMigrationInfoProvider.class, (Object)javaMigration)) {
            infoProvider = (JavaMigrationInfoProvider)((Object)javaMigration);
            this.schemaVersion = infoProvider.getVersion();
        } else {
            nameWithoutV = ClassUtils.getShortName(javaMigration.getClass()).substring(1);
            this.schemaVersion = MigrationInfoHelper.extractSchemaVersion(nameWithoutV);
        }
        if (ClassUtils.isAssignableValue(JavaMigrationInfoProvider.class, (Object)javaMigration)) {
            infoProvider = (JavaMigrationInfoProvider)((Object)javaMigration);
            this.description = infoProvider.getDescription();
        } else {
            nameWithoutV = ClassUtils.getShortName(javaMigration.getClass()).substring(1);
            this.description = MigrationInfoHelper.extractDescription(nameWithoutV);
        }
        this.script = javaMigration.getClass().getName();
    }

    public MigrationType getMigrationType() {
        return MigrationType.JAVA;
    }

    public void migrate(JdbcTemplate jdbcTemplate, DbSupport dbSupport) throws DataAccessException {
        try {
            this.javaMigration.migrate(jdbcTemplate);
        }
        catch (Exception e) {
            throw new FlywayException("Migration failed !", e);
        }
    }
}

