/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.db2.DB2DbSupport;
import com.googlecode.flyway.core.dbsupport.h2.H2DbSupport;
import com.googlecode.flyway.core.dbsupport.hsql.HsqlDbSupport;
import com.googlecode.flyway.core.dbsupport.mysql.MySQLDbSupport;
import com.googlecode.flyway.core.dbsupport.oracle.OracleDbSupport;
import com.googlecode.flyway.core.dbsupport.postgresql.PostgreSQLDbSupport;
import com.googlecode.flyway.core.dbsupport.sqlserver.SQLServerDbSupport;
import com.googlecode.flyway.core.exception.FlywayException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class DbSupportFactory {
    private static final Log LOG = LogFactory.getLog(DbSupportFactory.class);

    private DbSupportFactory() {
    }

    public static DbSupport createDbSupport(JdbcTemplate jdbcTemplate) {
        String databaseProductName = DbSupportFactory.getDatabaseProductName(jdbcTemplate);
        LOG.debug((Object)("Database: " + databaseProductName));
        if ("H2".equals(databaseProductName)) {
            return new H2DbSupport(jdbcTemplate);
        }
        if ("HSQL Database Engine".equals(databaseProductName)) {
            return new HsqlDbSupport(jdbcTemplate);
        }
        if ("Microsoft SQL Server".equals(databaseProductName)) {
            return new SQLServerDbSupport(jdbcTemplate);
        }
        if ("MySQL".equals(databaseProductName)) {
            return new MySQLDbSupport(jdbcTemplate);
        }
        if ("Oracle".equals(databaseProductName)) {
            return new OracleDbSupport(jdbcTemplate);
        }
        if ("PostgreSQL".equals(databaseProductName)) {
            return new PostgreSQLDbSupport(jdbcTemplate);
        }
        if (databaseProductName != null && databaseProductName.startsWith("DB2")) {
            return new DB2DbSupport(jdbcTemplate);
        }
        throw new FlywayException("Unsupported Database: " + databaseProductName);
    }

    private static String getDatabaseProductName(JdbcTemplate jdbcTemplate) {
        return (String)jdbcTemplate.execute(new ConnectionCallback(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                if (databaseMetaData == null) {
                    throw new FlywayException("Unable to read database metadata while it is null!");
                }
                return databaseMetaData.getDatabaseProductName();
            }
        });
    }
}

