/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.core.type.classreading;

import java.io.IOException;
import java.io.InputStream;
import org.springframework.asm.ClassReader;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.core.type.classreading.MetadataReaderFactory;
import org.springframework.core.type.classreading.SimpleMetadataReader;
import org.springframework.util.ClassUtils;

public class SimpleMetadataReaderFactory
implements MetadataReaderFactory {
    private final ResourceLoader resourceLoader;

    public SimpleMetadataReaderFactory() {
        this.resourceLoader = new DefaultResourceLoader();
    }

    public SimpleMetadataReaderFactory(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader != null ? resourceLoader : new DefaultResourceLoader();
    }

    public SimpleMetadataReaderFactory(ClassLoader classLoader) {
        this.resourceLoader = classLoader != null ? new DefaultResourceLoader(classLoader) : new DefaultResourceLoader();
    }

    public MetadataReader getMetadataReader(String className) throws IOException {
        String resourcePath = "classpath:" + ClassUtils.convertClassNameToResourcePath(className) + ".class";
        return this.getMetadataReader(this.resourceLoader.getResource(resourcePath));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MetadataReader getMetadataReader(Resource resource) throws IOException {
        InputStream is = resource.getInputStream();
        try {
            SimpleMetadataReader simpleMetadataReader = new SimpleMetadataReader(new ClassReader(is), this.resourceLoader.getClassLoader());
            return simpleMetadataReader;
        }
        finally {
            is.close();
        }
    }
}

