/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.commandline;

import com.googlecode.flyway.core.Flyway;
import com.googlecode.flyway.core.exception.FlywayException;
import com.googlecode.flyway.core.metadatatable.MetaDataTableRow;
import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.ClassUtils;
import com.googlecode.flyway.core.util.ExceptionUtils;
import com.googlecode.flyway.core.util.MetaDataTableRowDumper;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class Main {
    private static final Log LOG = LogFactory.getLog(Main.class);

    public static void main(String[] args) {
        try {
            Main.printVersion();
            String operation = Main.determineOperation(args);
            if (operation == null) {
                Main.printUsage();
                return;
            }
            Main.loadJdbcDriversAndJavaMigrations();
            Flyway flyway = new Flyway();
            Properties properties = new Properties();
            Main.initializeDefaults(properties);
            Main.loadConfigurationFile(properties, args);
            Main.overrideConfiguration(properties, args);
            flyway.configure(properties);
            if ("clean".equals(operation)) {
                flyway.clean();
            } else if ("init".equals(operation)) {
                flyway.init();
            } else if ("migrate".equals(operation)) {
                flyway.migrate();
            } else if ("validate".equals(operation)) {
                flyway.validate();
            } else if ("status".equals(operation)) {
                MetaDataTableRowDumper.dumpMigration((MetaDataTableRow)flyway.status());
            } else if ("history".equals(operation)) {
                MetaDataTableRowDumper.dumpMigrations((List)flyway.history());
            } else {
                Main.printUsage();
            }
        }
        catch (Exception e) {
            LOG.error((Object)(ClassUtils.getShortName(e.getClass()) + ": " + e.getMessage()));
            Main.outputFirstStackTraceElement(e);
            Throwable rootCause = ExceptionUtils.getRootCause((Throwable)e);
            if (rootCause != null) {
                LOG.error((Object)("Caused by " + rootCause.toString()));
                Main.outputFirstStackTraceElement(rootCause);
            }
            System.exit(1);
        }
    }

    private static void outputFirstStackTraceElement(Throwable t) {
        StackTraceElement firstStackTraceElement = t.getStackTrace()[0];
        LOG.error((Object)("Occured in " + firstStackTraceElement.getClassName() + " in method " + firstStackTraceElement.getMethodName() + ", line number " + firstStackTraceElement.getLineNumber()));
    }

    private static void initializeDefaults(Properties properties) {
        properties.put("flyway.password", "");
        properties.put("flyway.baseDir", "");
    }

    private static void printVersion() throws IOException {
        String version = new ClassPathResource("version.txt").loadAsString("UTF-8");
        LOG.info((Object)("Flyway (Command-line Tool) v." + version));
        LOG.info((Object)"");
    }

    private static void printUsage() {
        String extension = Main.isWindows() ? "cmd" : "sh";
        LOG.info((Object)"********");
        LOG.info((Object)"* Usage");
        LOG.info((Object)"********");
        LOG.info((Object)"");
        LOG.info((Object)("flyway." + extension + " [options] command"));
        LOG.info((Object)"");
        LOG.info((Object)"By default, the configuration will be read from conf/flyway.properties.");
        LOG.info((Object)"Options passed from the command-line override the configuration.");
        LOG.info((Object)"");
        LOG.info((Object)"Commands");
        LOG.info((Object)"========");
        LOG.info((Object)"clean    : Drops all objects in the schema without dropping the schema itself");
        LOG.info((Object)"init     : Creates and initializes the metadata table in the schema");
        LOG.info((Object)"migrate  : Migrates the schema to the latest version");
        LOG.info((Object)"validate : Validates the applied migrations against the ones on the classpath");
        LOG.info((Object)"status   : Prints the current version of the schema");
        LOG.info((Object)"history  : Prints the full migration history of the schema");
        LOG.info((Object)"");
        LOG.info((Object)"Options (Format: -key=value)");
        LOG.info((Object)"=======");
        LOG.info((Object)"driver              : Fully qualified classname of the jdbc driver");
        LOG.info((Object)"url                 : Jdbc url to use to connect to the database");
        LOG.info((Object)"user                : User to use to connect to the database");
        LOG.info((Object)"password            : Password to use to connect to the database");
        LOG.info((Object)"schemas             : Comma-separated list of the schemas managed by Flyway");
        LOG.info((Object)"table               : Name of Flyway's metadata table");
        LOG.info((Object)"basePackage         : Package to scan for Java migrations");
        LOG.info((Object)"baseDir             : Directory on the classpath to scan for Sql migrations");
        LOG.info((Object)"sqlMigrationPrefix  : File name prefix for Sql migrations");
        LOG.info((Object)"sqlMigrationSuffix  : File name suffix for Sql migrations");
        LOG.info((Object)"encoding            : Encoding of Sql migrations");
        LOG.info((Object)"placeholders        : Placeholders to replace in Sql migrations");
        LOG.info((Object)"placeholderPrefix   : Prefix of every placeholder");
        LOG.info((Object)"placeholderSuffix   : Suffix of every placeholder");
        LOG.info((Object)"target              : Target version up to which Flyway should run migrations");
        LOG.info((Object)"validationMode      : Type of validation to be performed before migrating");
        LOG.info((Object)"validationErrorMode : Action to take when validation fails");
        LOG.info((Object)"initialVersion      : Initial version to put in the database");
        LOG.info((Object)"initialDescription  : Description of the initial version");
        LOG.info((Object)"disableInitCheck    : Don't check that a non-empty schema has been initialized");
        LOG.info((Object)"configFile          : Config file to use (default: conf/flyway.properties)");
        LOG.info((Object)"configFileEncoding  : Encoding of the config file (default: UTF-8)");
        LOG.info((Object)"");
        LOG.info((Object)"Example");
        LOG.info((Object)"=======");
        LOG.info((Object)("flyway." + extension + " -target=1.5 -placeholder.user=my_user history"));
        LOG.info((Object)"");
        LOG.info((Object)"More info at http://code.google.com/p/flyway/wiki/CommandLine");
    }

    private static boolean isWindows() {
        return System.getProperty("os.name").startsWith("Windows");
    }

    private static void loadJdbcDriversAndJavaMigrations() throws Exception {
        String directoryForJdbcDriversAndJavaMigrations = Main.getInstallationDir() + "/jars";
        File dir = new File(directoryForJdbcDriversAndJavaMigrations);
        File[] files = dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        });
        if (files == null) {
            LOG.warn((Object)("Directory for JDBC drivers and JavaMigrations not found: " + directoryForJdbcDriversAndJavaMigrations));
            return;
        }
        for (File file : files) {
            Main.addJarOrDirectoryToClasspath(file.getPath());
        }
    }

    static void addJarOrDirectoryToClasspath(String name) throws Exception {
        LOG.debug((Object)("Adding location to classpath: " + name));
        URLClassLoader urlClassLoader = new URLClassLoader(new URL[]{new File(name).toURI().toURL()}, Thread.currentThread().getContextClassLoader());
        Thread.currentThread().setContextClassLoader(urlClassLoader);
    }

    static void loadConfigurationFile(Properties properties, String[] args) throws FlywayException {
        String configFile = Main.determineConfigurationFile(args);
        if (configFile != null) {
            try {
                PropertiesFactoryBean propertiesFactoryBean = new PropertiesFactoryBean();
                propertiesFactoryBean.setFileEncoding(Main.determineConfigurationFileEncoding(args));
                propertiesFactoryBean.setLocation((Resource)new FileSystemResource(configFile));
                propertiesFactoryBean.setProperties(properties);
                propertiesFactoryBean.afterPropertiesSet();
                properties.clear();
                properties.putAll((Map<?, ?>)((Properties)propertiesFactoryBean.getObject()));
            }
            catch (IOException e) {
                throw new FlywayException("Unable to load config file: " + configFile, (Throwable)e);
            }
        }
    }

    private static String determineConfigurationFile(String[] args) {
        for (String arg : args) {
            if (!Main.isPropertyArgument(arg) || !"configFile".equals(Main.getArgumentProperty(arg))) continue;
            return Main.getArgumentValue(arg);
        }
        return Main.getInstallationDir() + "/conf/flyway.properties";
    }

    private static String getInstallationDir() {
        String url = Main.class.getProtectionDomain().getCodeSource().getLocation().getPath();
        try {
            String path = URLDecoder.decode(url, "UTF-8");
            return path.substring(0, path.lastIndexOf("/")) + "/..";
        }
        catch (UnsupportedEncodingException e) {
            return null;
        }
    }

    private static String determineConfigurationFileEncoding(String[] args) {
        for (String arg : args) {
            if (!Main.isPropertyArgument(arg) || !"configFileEncoding".equals(Main.getArgumentProperty(arg))) continue;
            return Main.getArgumentValue(arg);
        }
        return "UTF-8";
    }

    static void overrideConfiguration(Properties properties, String[] args) {
        for (String arg : args) {
            if (!Main.isPropertyArgument(arg)) continue;
            properties.put("flyway." + Main.getArgumentProperty(arg), Main.getArgumentValue(arg));
        }
    }

    static boolean isPropertyArgument(String arg) {
        return arg.startsWith("-") && arg.contains("=");
    }

    static String getArgumentProperty(String arg) {
        int index = arg.indexOf("=");
        return arg.substring(1, index);
    }

    static String getArgumentValue(String arg) {
        int index = arg.indexOf("=");
        if (index < 0 || index == arg.length()) {
            return "";
        }
        return arg.substring(index + 1);
    }

    private static String determineOperation(String[] args) {
        for (String arg : args) {
            if (arg.startsWith("-")) continue;
            return arg;
        }
        return null;
    }
}

