/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util.jdbc;

import com.googlecode.flyway.core.util.jdbc.TransactionCallback;
import com.googlecode.flyway.core.util.jdbc.TransactionException;
import java.sql.Connection;
import java.sql.SQLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TransactionTemplate {
    private static final Log LOG = LogFactory.getLog(TransactionTemplate.class);
    private final Connection connection;

    public TransactionTemplate(Connection connection) {
        this.connection = connection;
    }

    public <T> T execute(TransactionCallback<T> transactionCallback) throws TransactionException {
        try {
            this.connection.setAutoCommit(false);
            T result = transactionCallback.doInTransaction();
            this.connection.commit();
            return result;
        }
        catch (SQLException e) {
            try {
                this.connection.rollback();
                throw new TransactionException("Transaction failed!", e);
            }
            catch (SQLException se) {
                LOG.error((Object)"Unable to rollback transaction", (Throwable)e);
                throw new TransactionException("Error while executing transaction. Roll back failed!", e);
            }
        }
        catch (RuntimeException e) {
            try {
                this.connection.rollback();
                throw e;
            }
            catch (SQLException se) {
                LOG.error((Object)"Unable to rollback transaction", (Throwable)e);
                throw new TransactionException("Error while executing transaction. Roll back failed!", e);
            }
        }
    }
}

