/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util.scanner.jboss;

import com.googlecode.flyway.core.util.scanner.LocationScanner;
import java.io.IOException;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;
import org.jboss.vfs.VirtualFileFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JBossVFSLocationScanner
implements LocationScanner {
    private static final Log LOG = LogFactory.getLog(JBossVFSLocationScanner.class);

    @Override
    public Set<String> findResourceNames(String location, String locationUrl) throws IOException {
        String classPathRootOnDisk = locationUrl.substring(0, locationUrl.length() - location.length());
        if (!classPathRootOnDisk.endsWith("/")) {
            classPathRootOnDisk = classPathRootOnDisk + "/";
        }
        LOG.debug((Object)("Scanning starting at classpath root on JBoss VFS: " + classPathRootOnDisk));
        TreeSet<String> resourceNames = new TreeSet<String>();
        List files = VFS.getChild((String)locationUrl).getChildrenRecursively(new VirtualFileFilter(){

            public boolean accepts(VirtualFile file) {
                return file.isFile();
            }
        });
        for (VirtualFile file : files) {
            resourceNames.add(file.getPathName().substring(classPathRootOnDisk.length()));
        }
        return resourceNames;
    }
}

