/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.sqlserver;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.SqlScript;
import com.googlecode.flyway.core.dbsupport.SqlStatement;
import com.googlecode.flyway.core.dbsupport.SqlStatementBuilder;
import com.googlecode.flyway.core.dbsupport.sqlserver.SQLServerJdbcTemplate;
import com.googlecode.flyway.core.dbsupport.sqlserver.SQLServerSqlStatementBuilder;
import com.googlecode.flyway.core.util.StringUtils;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLServerDbSupport
extends DbSupport {
    private static final Log LOG = LogFactory.getLog(SQLServerDbSupport.class);

    public SQLServerDbSupport(Connection connection) {
        super(new SQLServerJdbcTemplate(connection));
    }

    @Override
    public String getScriptLocation() {
        return "com/googlecode/flyway/core/dbsupport/sqlserver/";
    }

    @Override
    public String getCurrentUserFunction() {
        return "SUSER_NAME()";
    }

    @Override
    public String getCurrentSchema() throws SQLException {
        return this.jdbcTemplate.queryForString("SELECT SCHEMA_NAME()", new String[0]);
    }

    @Override
    public void setCurrentSchema(String schema) throws SQLException {
        LOG.info("SQLServer does not support setting the schema for the current session. Default schema not changed to " + schema);
    }

    @Override
    public boolean isSchemaEmpty(String schema) throws SQLException {
        int objectCount = this.jdbcTemplate.queryForInt("Select count(*) FROM ( Select TABLE_NAME as OBJECT_NAME, TABLE_SCHEMA as OBJECT_SCHEMA from INFORMATION_SCHEMA.TABLES Union Select TABLE_NAME as OBJECT_NAME, TABLE_SCHEMA as OBJECT_SCHEMA from INFORMATION_SCHEMA.VIEWS Union Select CONSTRAINT_NAME as OBJECT_NAME, TABLE_SCHEMA as OBJECT_SCHEMA from INFORMATION_SCHEMA.TABLE_CONSTRAINTS Union Select ROUTINE_NAME as OBJECT_NAME, ROUTINE_SCHEMA as OBJECT_SCHEMA from INFORMATION_SCHEMA.ROUTINES ) R where OBJECT_SCHEMA = ?", schema);
        return objectCount == 0;
    }

    @Override
    public boolean tableExistsNoQuotes(String schema, String table) throws SQLException {
        return this.jdbcTemplate.tableExists(null, schema, table, new String[0]);
    }

    @Override
    public boolean tableExists(String schema, String table) throws SQLException {
        return this.jdbcTemplate.tableExists(null, schema, table, new String[0]);
    }

    @Override
    public boolean columnExists(String schema, String table, String column) throws SQLException {
        return this.jdbcTemplate.columnExists(null, schema, table, column);
    }

    @Override
    public boolean primaryKeyExists(String schema, String table) throws SQLException {
        return this.jdbcTemplate.primaryKeyExists(null, schema, table);
    }

    @Override
    public boolean supportsDdlTransactions() {
        return true;
    }

    @Override
    public void lockTable(String schema, String table) throws SQLException {
        this.jdbcTemplate.execute("select * from " + this.quote(schema) + "." + this.quote(table) + " WITH (TABLOCKX)", new Object[0]);
    }

    @Override
    public String getBooleanTrue() {
        return "1";
    }

    @Override
    public String getBooleanFalse() {
        return "0";
    }

    @Override
    public SqlStatementBuilder createSqlStatementBuilder() {
        return new SQLServerSqlStatementBuilder();
    }

    @Override
    public SqlScript createCleanScript(String schema) throws SQLException {
        List<String> statements = this.cleanForeignKeys(schema);
        statements.addAll(this.cleanRoutines(schema));
        statements.addAll(this.cleanViews(schema));
        statements.addAll(this.cleanTables(schema));
        statements.addAll(this.cleanTypes(schema));
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        int lineNumber = 1;
        for (String statement : statements) {
            sqlStatements.add(new SqlStatement(lineNumber, statement));
            ++lineNumber;
        }
        return new SqlScript(sqlStatements, (DbSupport)this);
    }

    private String escapeIdentifier(String identifier) {
        return StringUtils.replaceAll(identifier, "]", "]]");
    }

    private List<String> cleanTables(String schema) throws SQLException {
        List<String> tableNames = this.jdbcTemplate.queryForStringList("SELECT table_name FROM INFORMATION_SCHEMA.TABLES WHERE table_type='BASE TABLE' and table_schema=?", schema);
        ArrayList<String> statements = new ArrayList<String>();
        for (String tableName : tableNames) {
            statements.add("DROP TABLE [" + schema + "].[" + this.escapeIdentifier(tableName) + "]");
        }
        return statements;
    }

    private List<String> cleanForeignKeys(String schema) throws SQLException {
        List<Map<String, String>> constraintNames = this.jdbcTemplate.queryForList("SELECT table_name, constraint_name FROM INFORMATION_SCHEMA.TABLE_CONSTRAINTS WHERE constraint_type = 'FOREIGN KEY' and table_schema=?", schema);
        ArrayList<String> statements = new ArrayList<String>();
        for (Map<String, String> row : constraintNames) {
            String tableName = row.get("table_name");
            String constraintName = row.get("constraint_name");
            statements.add("ALTER TABLE [" + schema + "].[" + tableName + "] DROP CONSTRAINT [" + constraintName + "]");
        }
        return statements;
    }

    private List<String> cleanRoutines(String schema) throws SQLException {
        List<Map<String, String>> routineNames = this.jdbcTemplate.queryForList("SELECT routine_name, routine_type FROM INFORMATION_SCHEMA.ROUTINES WHERE routine_schema=?", schema);
        ArrayList<String> statements = new ArrayList<String>();
        for (Map<String, String> row : routineNames) {
            String routineName = row.get("routine_name");
            String routineType = row.get("routine_type");
            statements.add("DROP " + routineType + " [" + schema + "].[" + routineName + "]");
        }
        return statements;
    }

    private List<String> cleanViews(String schema) throws SQLException {
        List<String> viewNames = this.jdbcTemplate.queryForStringList("SELECT table_name FROM INFORMATION_SCHEMA.VIEWS WHERE table_schema=?", schema);
        ArrayList<String> statements = new ArrayList<String>();
        for (String viewName : viewNames) {
            statements.add("DROP VIEW [" + schema + "].[" + viewName + "]");
        }
        return statements;
    }

    private List<String> cleanTypes(String schema) throws SQLException {
        List<String> typeNames = this.jdbcTemplate.queryForStringList("SELECT t.name FROM sys.types t INNER JOIN sys.schemas s ON t.schema_id = s.schema_id WHERE t.is_user_defined = 1 AND s.name = ?", schema);
        ArrayList<String> statements = new ArrayList<String>();
        for (String typeName : typeNames) {
            statements.add("DROP TYPE [" + schema + "].[" + typeName + "]");
        }
        return statements;
    }

    @Override
    public String doQuote(String identifier) {
        return "[" + identifier + "]";
    }
}

