/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport;

import com.googlecode.flyway.core.dbsupport.Delimiter;
import com.googlecode.flyway.core.dbsupport.SqlStatement;

public class SqlStatementBuilder {
    private StringBuilder statement = new StringBuilder();
    private int lineNumber;
    private boolean empty = true;
    private boolean terminated;
    private Delimiter delimiter = this.getDefaultDelimiter();

    protected Delimiter getDefaultDelimiter() {
        return new Delimiter(";", false);
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void setDelimiter(Delimiter delimiter) {
        this.delimiter = delimiter;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public boolean isTerminated() {
        return this.terminated;
    }

    public SqlStatement getSqlStatement() {
        return new SqlStatement(this.lineNumber, this.statement.toString());
    }

    public Delimiter extractNewDelimiterFromLine(String line) {
        return null;
    }

    public boolean isCommentDirective(String line) {
        return false;
    }

    public boolean isSingleLineComment(String line) {
        return line.startsWith("--");
    }

    public void addLine(String line) {
        if (this.isEmpty()) {
            this.empty = false;
        } else {
            this.statement.append("\n");
        }
        String lineSimplified = line.replaceAll("\\s+", " ").trim().toUpperCase();
        if (this.endsWithOpenMultilineStringLiteral(lineSimplified)) {
            this.statement.append(line);
            return;
        }
        this.delimiter = this.changeDelimiterIfNecessary(lineSimplified, this.delimiter);
        this.statement.append(line);
        if (this.lineTerminatesStatement(lineSimplified, this.delimiter)) {
            this.statement = new StringBuilder(SqlStatementBuilder.stripDelimiter(this.statement.toString(), this.delimiter));
            this.terminated = true;
        }
    }

    protected boolean endsWithOpenMultilineStringLiteral(String line) {
        return false;
    }

    protected Delimiter changeDelimiterIfNecessary(String line, Delimiter delimiter) {
        return delimiter;
    }

    private boolean lineTerminatesStatement(String line, Delimiter delimiter) {
        if (delimiter == null) {
            return false;
        }
        String upperCaseDelimiter = delimiter.getDelimiter().toUpperCase();
        if (delimiter.isAloneOnLine()) {
            return line.equals(upperCaseDelimiter);
        }
        return line.endsWith(upperCaseDelimiter);
    }

    private static String stripDelimiter(String sql, Delimiter delimiter) {
        return sql.substring(0, sql.toUpperCase().lastIndexOf(delimiter.getDelimiter().toUpperCase()));
    }
}

