/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.metadatatable;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.api.MigrationType;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.SqlScript;
import com.googlecode.flyway.core.metadatatable.AppliedMigration;
import com.googlecode.flyway.core.metadatatable.MetaDataTable;
import com.googlecode.flyway.core.util.ClassPathResource;
import com.googlecode.flyway.core.util.PlaceholderReplacer;
import com.googlecode.flyway.core.util.StopWatch;
import com.googlecode.flyway.core.util.TimeFormat;
import com.googlecode.flyway.core.util.jdbc.RowMapper;
import com.googlecode.flyway.core.util.jdbc.TransactionCallback;
import com.googlecode.flyway.core.util.jdbc.TransactionTemplate;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MetaDataTableImpl
implements MetaDataTable {
    private static final Log LOG = LogFactory.getLog(MetaDataTableImpl.class);
    private final DbSupport dbSupport;
    private final String schema;
    private final String table;
    private final Connection connection;
    private final JdbcTemplate jdbcTemplate;

    public MetaDataTableImpl(Connection connection, DbSupport dbSupport, String schema, String table) {
        this.connection = connection;
        this.jdbcTemplate = dbSupport.getJdbcTemplate();
        this.dbSupport = dbSupport;
        this.schema = schema;
        this.table = table;
    }

    private boolean exists() {
        try {
            return this.dbSupport.tableExists(this.schema, this.table);
        }
        catch (SQLException e) {
            throw new FlywayException("Error checking whether metadata table (" + this.fullyQualifiedMetadataTableName() + ") exists", e);
        }
    }

    private void create() {
        LOG.info("Creating Metadata table: " + this.fullyQualifiedMetadataTableName());
        String source = new ClassPathResource(this.dbSupport.getScriptLocation() + "createMetaDataTable.sql").loadAsString("UTF-8");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("schema", this.schema);
        placeholders.put("table", this.table);
        final String sourceNoPlaceholders = new PlaceholderReplacer(placeholders, "${", "}").replacePlaceholders(source);
        new TransactionTemplate(this.connection).execute(new TransactionCallback<Void>(){

            @Override
            public Void doInTransaction() {
                SqlScript sqlScript = new SqlScript(sourceNoPlaceholders, MetaDataTableImpl.this.dbSupport);
                sqlScript.execute(MetaDataTableImpl.this.jdbcTemplate);
                return null;
            }
        });
        LOG.debug("Metadata table created: " + this.fullyQualifiedMetadataTableName());
    }

    @Override
    public void createIfNotExists() {
        if (!this.exists()) {
            this.create();
        }
    }

    @Override
    public void lock() {
        try {
            this.dbSupport.lockTable(this.schema, this.table);
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to lock metadata table (" + this.fullyQualifiedMetadataTableName() + ")", e);
        }
    }

    @Override
    public void insert(AppliedMigration appliedMigration) {
        MigrationVersion version = appliedMigration.getVersion();
        try {
            int versionRank = this.calculateVersionRank(version);
            this.jdbcTemplate.update("UPDATE " + this.fullyQualifiedMetadataTableName() + " SET " + this.dbSupport.quote("version_rank") + " = " + this.dbSupport.quote("version_rank") + " + 1 WHERE " + this.dbSupport.quote("version_rank") + " >= ?", versionRank);
            this.jdbcTemplate.update("INSERT INTO " + this.fullyQualifiedMetadataTableName() + " (" + this.dbSupport.quote("version_rank") + "," + this.dbSupport.quote("installed_rank") + "," + this.dbSupport.quote("version") + "," + this.dbSupport.quote("description") + "," + this.dbSupport.quote("type") + "," + this.dbSupport.quote("script") + "," + this.dbSupport.quote("checksum") + "," + this.dbSupport.quote("installed_by") + "," + this.dbSupport.quote("execution_time") + "," + this.dbSupport.quote("success") + ")" + " VALUES (?, ?, ?, ?, ?, ?, ?, " + this.dbSupport.getCurrentUserFunction() + ", ?, ?)", versionRank, this.calculateInstalledRank(), version.toString(), appliedMigration.getDescription(), appliedMigration.getType().name(), appliedMigration.getScript(), appliedMigration.getChecksum(), appliedMigration.getExecutionTime(), appliedMigration.isSuccess());
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to insert metadata table row for version " + version, e);
        }
    }

    private int calculateInstalledRank() throws SQLException {
        int currentMax = this.jdbcTemplate.queryForInt("SELECT MAX(" + this.dbSupport.quote("installed_rank") + ")" + " FROM " + this.fullyQualifiedMetadataTableName(), new String[0]);
        return currentMax + 1;
    }

    private int calculateVersionRank(MigrationVersion version) throws SQLException {
        List<String> versions = this.jdbcTemplate.queryForStringList("select " + this.dbSupport.quote("version") + " from " + this.fullyQualifiedMetadataTableName(), new String[0]);
        ArrayList<MigrationVersion> migrationVersions = new ArrayList<MigrationVersion>();
        for (String versionStr : versions) {
            migrationVersions.add(new MigrationVersion(versionStr));
        }
        Collections.sort(migrationVersions);
        for (int i = 0; i < migrationVersions.size(); ++i) {
            if (version.compareTo((MigrationVersion)migrationVersions.get(i)) >= 0) continue;
            return i + 1;
        }
        return migrationVersions.size() + 1;
    }

    private boolean hasRows() {
        if (!this.exists()) {
            return false;
        }
        try {
            return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this.fullyQualifiedMetadataTableName(), new String[0]) > 0;
        }
        catch (SQLException e) {
            throw new FlywayException("Error checking if the metadata table has at least one row", e);
        }
    }

    @Override
    public List<AppliedMigration> allAppliedMigrations() {
        if (!this.exists()) {
            return new ArrayList<AppliedMigration>();
        }
        String query = "SELECT " + this.dbSupport.quote("version_rank") + "," + this.dbSupport.quote("installed_rank") + "," + this.dbSupport.quote("version") + "," + this.dbSupport.quote("description") + "," + this.dbSupport.quote("type") + "," + this.dbSupport.quote("script") + "," + this.dbSupport.quote("checksum") + "," + this.dbSupport.quote("installed_on") + "," + this.dbSupport.quote("installed_by") + "," + this.dbSupport.quote("execution_time") + "," + this.dbSupport.quote("success") + " FROM " + this.fullyQualifiedMetadataTableName() + " ORDER BY " + this.dbSupport.quote("version_rank");
        try {
            return this.jdbcTemplate.query(query, new RowMapper<AppliedMigration>(){

                @Override
                public AppliedMigration mapRow(ResultSet rs) throws SQLException {
                    return new AppliedMigration(rs.getInt("version_rank"), rs.getInt("installed_rank"), new MigrationVersion(rs.getString("version")), rs.getString("description"), MigrationType.valueOf(rs.getString("type")), rs.getString("script"), MetaDataTableImpl.this.toInteger((Number)rs.getObject("checksum")), rs.getTimestamp("installed_on"), rs.getString("installed_by"), MetaDataTableImpl.this.toInteger((Number)rs.getObject("execution_time")), rs.getBoolean("success"));
                }
            });
        }
        catch (SQLException e) {
            throw new FlywayException("Error while retrieving the list of applied migrations", e);
        }
    }

    private Integer toInteger(Number number) {
        if (number == null) {
            return null;
        }
        return number.intValue();
    }

    @Override
    public boolean hasFailedMigration() {
        if (!this.exists()) {
            return false;
        }
        try {
            int failedCount = this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this.fullyQualifiedMetadataTableName() + " WHERE " + this.dbSupport.quote("success") + "=" + this.dbSupport.getBooleanFalse(), new String[0]);
            return failedCount > 0;
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to check the metadata table (" + this.fullyQualifiedMetadataTableName() + ") for failed migrations", e);
        }
    }

    private String fullyQualifiedMetadataTableName() {
        return this.dbSupport.quote(this.schema, this.table);
    }

    @Override
    public MigrationVersion getCurrentSchemaVersion() {
        if (!this.hasRows()) {
            return MigrationVersion.EMPTY;
        }
        String query = "SELECT " + this.dbSupport.quote("version") + " FROM " + this.fullyQualifiedMetadataTableName() + " WHERE " + this.dbSupport.quote("version_rank") + "IN (SELECT MAX(" + this.dbSupport.quote("version_rank") + ") FROM " + this.fullyQualifiedMetadataTableName() + ")";
        try {
            String version = this.jdbcTemplate.queryForString(query, new String[0]);
            return new MigrationVersion(version);
        }
        catch (SQLException e) {
            throw new FlywayException("Error determining current schema version", e);
        }
    }

    @Override
    public void repair() {
        if (!this.hasFailedMigration()) {
            LOG.info("Repair not necessary. No failed migration detected.");
            return;
        }
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        try {
            this.jdbcTemplate.execute("DELETE FROM " + this.fullyQualifiedMetadataTableName() + " WHERE " + this.dbSupport.quote("success") + " = " + this.dbSupport.getBooleanFalse(), new Object[0]);
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to repair metadata table", e);
        }
        stopWatch.stop();
        LOG.info("Metadata successfully repaired (execution time " + TimeFormat.format(stopWatch.getTotalTimeMillis()) + ").");
        LOG.info("Manual cleanup of the remaining effects the failed migration may still be required.");
    }
}

