/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util.scanner;

import com.googlecode.flyway.core.util.UrlUtils;
import com.googlecode.flyway.core.util.logging.Log;
import com.googlecode.flyway.core.util.logging.LogFactory;
import com.googlecode.flyway.core.util.scanner.LocationScanner;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileSystemLocationScanner
implements LocationScanner {
    private static final Log LOG = LogFactory.getLog(FileSystemLocationScanner.class);

    @Override
    public Set<String> findResourceNames(String location, URL locationUrl) throws IOException {
        String filePath = UrlUtils.toFilePath(locationUrl);
        String classPathRootOnDisk = filePath.substring(0, filePath.length() - location.length());
        if (!classPathRootOnDisk.endsWith("/")) {
            classPathRootOnDisk = classPathRootOnDisk + "/";
        }
        LOG.debug("Scanning starting at classpath root in filesystem: " + classPathRootOnDisk);
        return this.findResourceNamesFromFileSystem(classPathRootOnDisk, location, new File(filePath));
    }

    Set<String> findResourceNamesFromFileSystem(String classPathRootOnDisk, String scanRootLocation, File folder) throws IOException {
        File[] files;
        LOG.debug("Scanning for resources in path: " + folder.getPath() + " (classpath location: " + scanRootLocation + ")");
        TreeSet<String> resourceNames = new TreeSet<String>();
        for (File file : files = folder.listFiles()) {
            if (!file.canRead()) continue;
            if (file.isDirectory()) {
                resourceNames.addAll(this.findResourceNamesFromFileSystem(classPathRootOnDisk, scanRootLocation, file));
                continue;
            }
            resourceNames.add(this.toResourceNameOnClasspath(classPathRootOnDisk, file));
        }
        return resourceNames;
    }

    private String toResourceNameOnClasspath(String classPathRootOnDisk, File file) throws IOException {
        String fileName = URLDecoder.decode(file.toURI().toURL().getFile(), "UTF-8");
        return fileName.substring(classPathRootOnDisk.length());
    }
}

