/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport;

import com.googlecode.flyway.core.api.FlywayException;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.JdbcTemplate;
import com.googlecode.flyway.core.dbsupport.Table;
import java.sql.SQLException;

public abstract class Schema {
    protected final JdbcTemplate jdbcTemplate;
    protected final DbSupport dbSupport;
    protected final String name;

    public Schema(JdbcTemplate jdbcTemplate, DbSupport dbSupport, String name) {
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public boolean exists() {
        try {
            return this.doExists();
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to check whether schema " + this + " exists", e);
        }
    }

    protected abstract boolean doExists() throws SQLException;

    public boolean empty() {
        try {
            return this.doEmpty();
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to check whether schema " + this + " is empty", e);
        }
    }

    protected abstract boolean doEmpty() throws SQLException;

    public void create() {
        try {
            this.doCreate();
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to create schema " + this, e);
        }
    }

    protected abstract void doCreate() throws SQLException;

    public void drop() {
        try {
            this.doDrop();
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to drop schema " + this, e);
        }
    }

    protected abstract void doDrop() throws SQLException;

    public void clean() {
        try {
            this.doClean();
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to clean schema " + this, e);
        }
    }

    protected abstract void doClean() throws SQLException;

    public Table[] allTables() {
        try {
            return this.doAllTables();
        }
        catch (SQLException e) {
            throw new FlywayException("Unable to retrieve all tables in schema " + this, e);
        }
    }

    protected abstract Table[] doAllTables() throws SQLException;

    public abstract Table getTable(String var1);

    public String toString() {
        return this.dbSupport.quote(this.name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Schema schema = (Schema)o;
        return this.name.equals(schema.name);
    }

    public int hashCode() {
        return this.name.hashCode();
    }
}

