/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.resolver;

import com.googlecode.flyway.core.api.MigrationVersion;

public class MigrationResult {
    private final boolean success;
    private final MigrationVersion migrationVersion;
    private final Throwable errorCause;

    private MigrationResult(boolean success, MigrationVersion migrationVersion, Throwable errorCause) {
        this.success = success;
        this.migrationVersion = migrationVersion;
        this.errorCause = errorCause;
    }

    public static MigrationResult createSuccess(MigrationVersion migrationVersion) {
        return new MigrationResult(true, migrationVersion, null);
    }

    public static MigrationResult createFailed(MigrationVersion migrationVersion, Throwable cause) {
        return new MigrationResult(false, migrationVersion, cause);
    }

    public boolean isSuccess() {
        return this.success;
    }

    public MigrationVersion getMigrationVersion() {
        return this.migrationVersion;
    }

    public Throwable getErrorCause() {
        return this.errorCause;
    }
}

