/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.info;

import com.googlecode.flyway.core.api.MigrationInfo;
import com.googlecode.flyway.core.api.MigrationState;
import com.googlecode.flyway.core.api.MigrationType;
import com.googlecode.flyway.core.api.MigrationVersion;
import com.googlecode.flyway.core.info.MigrationInfoContext;
import com.googlecode.flyway.core.metadatatable.AppliedMigration;
import com.googlecode.flyway.core.resolver.ResolvedMigration;
import com.googlecode.flyway.core.util.ObjectUtils;
import java.util.Date;

public class MigrationInfoImpl
implements MigrationInfo {
    private final ResolvedMigration resolvedMigration;
    private final AppliedMigration appliedMigration;
    private final MigrationInfoContext context;

    public MigrationInfoImpl(ResolvedMigration resolvedMigration, AppliedMigration appliedMigration, MigrationInfoContext context) {
        this.resolvedMigration = resolvedMigration;
        this.appliedMigration = appliedMigration;
        this.context = context;
    }

    public ResolvedMigration getResolvedMigration() {
        return this.resolvedMigration;
    }

    public MigrationType getType() {
        if (this.resolvedMigration != null) {
            return this.resolvedMigration.getType();
        }
        return this.appliedMigration.getType();
    }

    public Integer getChecksum() {
        if (this.resolvedMigration != null) {
            return this.resolvedMigration.getChecksum();
        }
        return this.appliedMigration.getChecksum();
    }

    public MigrationVersion getVersion() {
        if (this.resolvedMigration != null) {
            return this.resolvedMigration.getVersion();
        }
        return this.appliedMigration.getVersion();
    }

    public String getDescription() {
        if (this.resolvedMigration != null) {
            return this.resolvedMigration.getDescription();
        }
        return this.appliedMigration.getDescription();
    }

    public String getScript() {
        if (this.resolvedMigration != null) {
            return this.resolvedMigration.getScript();
        }
        return this.appliedMigration.getScript();
    }

    public MigrationState getState() {
        if (this.appliedMigration == null) {
            if (this.resolvedMigration.getVersion().compareTo(this.context.init) < 0) {
                return MigrationState.PREINIT;
            }
            if (this.resolvedMigration.getVersion().compareTo(this.context.target) > 0) {
                return MigrationState.ABOVE_TARGET;
            }
            if (this.resolvedMigration.getVersion().compareTo(this.context.lastApplied) < 0 && !this.context.outOfOrder) {
                return MigrationState.IGNORED;
            }
            return MigrationState.PENDING;
        }
        if (this.resolvedMigration == null) {
            if (MigrationType.INIT == this.appliedMigration.getType()) {
                return MigrationState.SUCCESS;
            }
            if (this.getVersion().compareTo(this.context.lastResolved) < 0) {
                if (this.appliedMigration.isSuccess()) {
                    return MigrationState.MISSING_SUCCESS;
                }
                return MigrationState.MISSING_FAILED;
            }
            if (this.getVersion().compareTo(this.context.lastResolved) > 0) {
                if (this.appliedMigration.isSuccess()) {
                    return MigrationState.FUTURE_SUCCESS;
                }
                return MigrationState.FUTURE_FAILED;
            }
        }
        if (this.appliedMigration.isSuccess()) {
            if (this.appliedMigration.getVersionRank() == this.appliedMigration.getInstalledRank()) {
                return MigrationState.SUCCESS;
            }
            return MigrationState.OUT_OF_ORDER;
        }
        return MigrationState.FAILED;
    }

    public Date getInstalledOn() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getInstalledOn();
        }
        return null;
    }

    public Integer getExecutionTime() {
        if (this.appliedMigration != null) {
            return this.appliedMigration.getExecutionTime();
        }
        return null;
    }

    public String validate() {
        if (this.resolvedMigration == null && this.appliedMigration.getType() != MigrationType.SCHEMA && this.appliedMigration.getType() != MigrationType.INIT) {
            return "Detected applied migration missing on the classpath: " + this.getVersion();
        }
        if (this.resolvedMigration != null && this.appliedMigration != null && this.getVersion().compareTo(this.context.init) > 0) {
            if (this.resolvedMigration.getType() != this.appliedMigration.getType()) {
                return String.format("Migration Type mismatch for migration %s: DB=%s, Classpath=%s", new Object[]{this.appliedMigration.getScript(), this.appliedMigration.getType(), this.resolvedMigration.getType()});
            }
            if (!ObjectUtils.nullSafeEquals(this.resolvedMigration.getChecksum(), this.appliedMigration.getChecksum())) {
                return String.format("Migration Checksum mismatch for migration %s: DB=%s, Classpath=%s", this.appliedMigration.getScript(), this.appliedMigration.getChecksum(), this.resolvedMigration.getChecksum());
            }
        }
        return null;
    }

    public int compareTo(MigrationInfo o) {
        return this.getVersion().compareTo(o.getVersion());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MigrationInfoImpl that = (MigrationInfoImpl)o;
        if (this.appliedMigration != null ? !this.appliedMigration.equals(that.appliedMigration) : that.appliedMigration != null) {
            return false;
        }
        if (!this.context.equals(that.context)) {
            return false;
        }
        return !(this.resolvedMigration == null ? that.resolvedMigration != null : !this.resolvedMigration.equals(that.resolvedMigration));
    }

    public int hashCode() {
        int result = this.resolvedMigration != null ? this.resolvedMigration.hashCode() : 0;
        result = 31 * result + (this.appliedMigration != null ? this.appliedMigration.hashCode() : 0);
        result = 31 * result + this.context.hashCode();
        return result;
    }
}

