/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.flyway.core;

import com.google.code.flyway.core.Migration;
import com.google.code.flyway.core.MigrationState;
import com.google.code.flyway.core.SchemaVersion;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public abstract class BaseMigration
implements Migration {
    private static final Log log = LogFactory.getLog(BaseMigration.class);
    private SchemaVersion schemaVersion;
    private MigrationState migrationState = MigrationState.UNKNOWN;
    private long executionTime = -1L;

    @Override
    public SchemaVersion getVersion() {
        if (this.schemaVersion == null) {
            throw new IllegalStateException("SchemaVersion not initialized properly");
        }
        return this.schemaVersion;
    }

    protected final void initVersion(String migrationName) {
        this.schemaVersion = BaseMigration.extractSchemaVersion(migrationName);
    }

    static SchemaVersion extractSchemaVersion(String migrationName) {
        String version = migrationName.substring(1);
        String description = null;
        int descriptionPos = version.indexOf("__");
        if (descriptionPos != -1) {
            description = version.substring(descriptionPos + 2).replaceAll("_", " ");
            version = version.substring(0, descriptionPos);
        }
        return new SchemaVersion(version.replace("_", "."), description);
    }

    @Override
    public MigrationState getState() {
        return this.migrationState;
    }

    @Override
    public long getExecutionTime() {
        return this.executionTime;
    }

    @Override
    public final void migrate(SimpleJdbcTemplate jdbcTemplate) {
        long start = System.currentTimeMillis();
        try {
            this.doMigrate(jdbcTemplate);
            this.migrationState = MigrationState.SUCCESS;
        }
        catch (Exception e) {
            log.fatal((Object)("Migration failed: " + this.schemaVersion + " - " + this.getScriptName()), (Throwable)e);
            this.migrationState = MigrationState.FAILED;
        }
        long finish = System.currentTimeMillis();
        this.executionTime = finish - start;
    }

    protected abstract void doMigrate(SimpleJdbcTemplate var1) throws Exception;
}

