/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.flyway.core;

import com.google.code.flyway.core.DbSupport;
import com.google.code.flyway.core.MetaDataTable;
import com.google.code.flyway.core.Migration;
import com.google.code.flyway.core.MigrationResolver;
import com.google.code.flyway.core.MigrationState;
import com.google.code.flyway.core.SchemaVersion;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class DbMigrator {
    private static final Log log = LogFactory.getLog(DbMigrator.class);
    private final SchemaVersion targetVersion = SchemaVersion.LATEST;
    private final DbSupport dbSupport;
    private final Collection<MigrationResolver> migrationResolvers;
    private final MetaDataTable metaDataTable;
    private TransactionTemplate transactionTemplate;
    private SimpleJdbcTemplate jdbcTemplate;

    public DbMigrator(TransactionTemplate transactionTemplate, SimpleJdbcTemplate jdbcTemplate, DbSupport dbSupport, Collection<MigrationResolver> migrationResolvers, MetaDataTable metaDataTable) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.migrationResolvers = migrationResolvers;
        this.metaDataTable = metaDataTable;
    }

    public int migrate() throws Exception {
        if (!this.metaDataTable.exists()) {
            this.metaDataTable.create();
        }
        Migration latestAppliedMigration = this.metaDataTable.latestAppliedMigration();
        log.info((Object)("Current schema version: " + latestAppliedMigration.getVersion()));
        if (MigrationState.FAILED.equals((Object)latestAppliedMigration.getState())) {
            throw new IllegalStateException("A previous migration failed! Please restore backups and roll back database!");
        }
        List<Migration> pendingMigrations = this.getPendingMigrations(latestAppliedMigration.getVersion());
        if (pendingMigrations.isEmpty()) {
            log.info((Object)"Schema is up to date. No migration necessary.");
            return 0;
        }
        for (Migration pendingMigration : pendingMigrations) {
            log.debug((Object)("Pending migration: " + pendingMigration.getVersion() + " - " + pendingMigration.getScriptName()));
        }
        log.debug((Object)"Starting migration...");
        for (Migration migration : pendingMigrations) {
            log.info((Object)("Migrating to version " + migration.getVersion() + " - " + migration.getScriptName()));
            this.executeInTransaction(migration);
            if (MigrationState.FAILED.equals((Object)migration.getState()) && this.dbSupport.supportsDdlTransactions()) {
                throw new IllegalStateException("Migration failed! Changes rolled back. Aborting!");
            }
            this.metaDataTable.migrationFinished(migration);
            if (!MigrationState.FAILED.equals((Object)migration.getState())) continue;
            throw new IllegalStateException("Migration failed! Please restore backups and roll back database and code!");
        }
        if (pendingMigrations.size() == 1) {
            log.info((Object)"Migration completed. Successfully applied 1 migration.");
        } else {
            log.info((Object)("Migration completed. Successfully applied " + pendingMigrations.size() + " migrations."));
        }
        return pendingMigrations.size();
    }

    private void executeInTransaction(final Migration migration) {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                migration.migrate(DbMigrator.this.jdbcTemplate);
                return null;
            }
        });
    }

    private List<Migration> getPendingMigrations(SchemaVersion currentVersion) {
        ArrayList<Migration> allMigrations = new ArrayList<Migration>();
        for (MigrationResolver migrationResolver : this.migrationResolvers) {
            allMigrations.addAll(migrationResolver.resolvesMigrations());
        }
        if (allMigrations.isEmpty()) {
            log.warn((Object)"No migrations found!");
            return allMigrations;
        }
        Collections.sort(allMigrations, new Comparator<Migration>(){

            @Override
            public int compare(Migration o1, Migration o2) {
                return o2.getVersion().compareTo(o1.getVersion());
            }
        });
        SchemaVersion newestMigrationVersion = ((Migration)allMigrations.get(0)).getVersion();
        if (newestMigrationVersion.compareTo(currentVersion) < 0) {
            log.warn((Object)("Database version (" + currentVersion.getVersion() + ") is newer than the latest migration (" + newestMigrationVersion + ") !"));
            return new ArrayList<Migration>();
        }
        ArrayList<Migration> pendingMigrations = new ArrayList<Migration>();
        for (Migration migration : allMigrations) {
            if (migration.getVersion().compareTo(currentVersion) <= 0 || migration.getVersion().compareTo(this.targetVersion) > 0) continue;
            pendingMigrations.add(migration);
        }
        Collections.reverse(pendingMigrations);
        return pendingMigrations;
    }
}

