/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.flyway.core;

import com.google.code.flyway.core.DbMigrator;
import com.google.code.flyway.core.DbSupport;
import com.google.code.flyway.core.MetaDataTable;
import com.google.code.flyway.core.MigrationResolver;
import com.google.code.flyway.core.h2.H2DbSupport;
import com.google.code.flyway.core.hsql.HsqlDbSupport;
import com.google.code.flyway.core.java.JavaMigrationResolver;
import com.google.code.flyway.core.mysql.MySQLDbSupport;
import com.google.code.flyway.core.oracle.OracleDbSupport;
import com.google.code.flyway.core.sql.SqlMigrationResolver;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class Flyway {
    private static final Log log = LogFactory.getLog(Flyway.class);
    private String basePackage = "db.migration";
    private String baseDir = "db/migration";
    private String schemaMetaDataTable = "schema_version";
    private Map<String, String> placeholders;
    private SimpleJdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;
    private DbSupport dbSupport;
    private MetaDataTable metaDataTable;

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
    }

    public void setSchemaMetaDataTable(String schemaMetaDataTable) {
        this.schemaMetaDataTable = schemaMetaDataTable;
    }

    public void setPlaceholders(Map<String, String> placeholders) {
        this.placeholders = placeholders;
    }

    public MetaDataTable getMetaDataTable() {
        return this.metaDataTable;
    }

    public void setDataSource(DataSource dataSource) {
        DataSourceTransactionManager transactionManager = new DataSourceTransactionManager(dataSource);
        this.transactionTemplate = new TransactionTemplate((PlatformTransactionManager)transactionManager);
        this.jdbcTemplate = new SimpleJdbcTemplate(dataSource);
        this.dbSupport = this.initDbSupport();
        log.debug((Object)("Schema: " + this.dbSupport.getCurrentSchema(this.jdbcTemplate)));
        this.metaDataTable = new MetaDataTable(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, this.schemaMetaDataTable);
    }

    public int migrate() throws Exception {
        ArrayList<MigrationResolver> migrationResolvers = new ArrayList<MigrationResolver>();
        migrationResolvers.add(new SqlMigrationResolver(this.baseDir, this.placeholders, this.dbSupport));
        migrationResolvers.add(new JavaMigrationResolver(this.basePackage));
        DbMigrator dbMigrator = new DbMigrator(this.transactionTemplate, this.jdbcTemplate, this.dbSupport, migrationResolvers, this.metaDataTable);
        return dbMigrator.migrate();
    }

    private DbSupport initDbSupport() {
        String databaseProductName = (String)this.jdbcTemplate.getJdbcOperations().execute((ConnectionCallback)new ConnectionCallback<String>(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                if (databaseMetaData == null) {
                    throw new IllegalStateException("Unable to read database metadata while it is null!");
                }
                return connection.getMetaData().getDatabaseProductName();
            }
        });
        log.debug((Object)("Database: " + databaseProductName));
        ArrayList<DbSupport> dbSupports = new ArrayList<DbSupport>();
        dbSupports.add(new HsqlDbSupport());
        dbSupports.add(new H2DbSupport());
        dbSupports.add(new MySQLDbSupport());
        dbSupports.add(new OracleDbSupport());
        for (DbSupport dbSupport : dbSupports) {
            if (!dbSupport.supportsDatabase(databaseProductName)) continue;
            return dbSupport;
        }
        throw new IllegalArgumentException("Unsupported Database: " + databaseProductName);
    }
}

