/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.flyway.core;

import com.google.code.flyway.core.DbSupport;
import com.google.code.flyway.core.Migration;
import com.google.code.flyway.core.MigrationState;
import com.google.code.flyway.core.SchemaVersion;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class MetaDataTable {
    private DbSupport dbSupport;
    private final String tableName;
    private SimpleJdbcTemplate jdbcTemplate;
    private TransactionTemplate transactionTemplate;

    public MetaDataTable(TransactionTemplate transactionTemplate, SimpleJdbcTemplate jdbcTemplate, DbSupport dbSupport, String tableName) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.tableName = tableName;
    }

    public boolean exists() throws SQLException {
        return this.dbSupport.metaDataTableExists(this.jdbcTemplate, this.tableName);
    }

    public void create() {
        this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<Void>(){

            public Void doInTransaction(TransactionStatus status) {
                String[] statements;
                for (String statement : statements = MetaDataTable.this.dbSupport.createSchemaMetaDataTableSql(MetaDataTable.this.tableName)) {
                    MetaDataTable.this.jdbcTemplate.update(statement, new Object[0]);
                }
                return null;
            }
        });
    }

    public void migrationFinished(Migration migration) {
        this.jdbcTemplate.update("UPDATE " + this.tableName + " SET current_version=0", new Object[0]);
        this.jdbcTemplate.update("INSERT INTO " + this.tableName + " (version, description, script, execution_time, state, current_version)" + " VALUES (?, ?, ?, ?, ?, 1)", new Object[]{migration.getVersion().getVersion(), migration.getVersion().getDescription(), migration.getScriptName(), migration.getExecutionTime(), migration.getState().name()});
    }

    public Migration latestAppliedMigration() {
        final List result = this.jdbcTemplate.queryForList("select VERSION, DESCRIPTION, SCRIPT, EXECUTION_TIME, STATE from " + this.tableName + " where current_version=1", new Object[0]);
        if (result.isEmpty()) {
            return new Migration(){

                @Override
                public SchemaVersion getVersion() {
                    return SchemaVersion.EMPTY;
                }

                @Override
                public MigrationState getState() {
                    return MigrationState.UNKNOWN;
                }

                @Override
                public long getExecutionTime() {
                    return -1L;
                }

                @Override
                public String getScriptName() {
                    return null;
                }

                @Override
                public void migrate(SimpleJdbcTemplate jdbcTemplate) {
                }
            };
        }
        return new Migration(){

            @Override
            public SchemaVersion getVersion() {
                return new SchemaVersion((String)((Map)result.get(0)).get("VERSION"), (String)((Map)result.get(0)).get("DESCRIPTION"));
            }

            @Override
            public MigrationState getState() {
                return MigrationState.valueOf((String)((Map)result.get(0)).get("STATE"));
            }

            @Override
            public long getExecutionTime() {
                return (Long)((Map)result.get(0)).get("EXECUTION_TIME");
            }

            @Override
            public String getScriptName() {
                return (String)((Map)result.get(0)).get("SCRIPT");
            }

            @Override
            public void migrate(SimpleJdbcTemplate jdbcTemplate) {
            }
        };
    }
}

