/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.flyway.core.oracle;

import com.google.code.flyway.core.DbSupport;
import com.google.code.flyway.core.SqlScript;
import com.google.code.flyway.core.oracle.OracleSqlScript;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class OracleDbSupport
implements DbSupport {
    @Override
    public String[] createSchemaMetaDataTableSql(String tableName) {
        String createTableSql = "CREATE TABLE " + tableName + " (" + "    version VARCHAR2(20) NOT NULL PRIMARY KEY," + "    description VARCHAR2(100)," + "    script VARCHAR2(100) NOT NULL UNIQUE," + "    installed_on TIMESTAMP DEFAULT CURRENT_TIMESTAMP," + "    execution_time INT," + "    state VARCHAR2(15) NOT NULL," + "    current_version NUMBER(1) NOT NULL" + ")";
        String addIndexSql = "CREATE INDEX " + tableName + "_cv_idx ON " + tableName + "(current_version)";
        return new String[]{createTableSql, addIndexSql};
    }

    @Override
    public String getCurrentSchema(SimpleJdbcTemplate jdbcTemplate) {
        return (String)jdbcTemplate.getJdbcOperations().execute((ConnectionCallback)new ConnectionCallback<String>(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                return connection.getMetaData().getUserName();
            }
        });
    }

    @Override
    public boolean supportsDatabase(String databaseProductName) {
        return "Oracle".equals(databaseProductName);
    }

    @Override
    public boolean metaDataTableExists(SimpleJdbcTemplate jdbcTemplate, String schemaMetaDataTable) {
        int count = jdbcTemplate.queryForInt("SELECT count(*) FROM user_tables WHERE table_name = ?", new Object[]{schemaMetaDataTable.toUpperCase()});
        return count > 0;
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public SqlScript createSqlScript(Resource resource, Map<String, String> placeholders) {
        return new OracleSqlScript(resource, placeholders);
    }
}

