/*
 * Decompiled with CFR 0.152.
 */
package com.google.code.flyway.core.sql;

import com.google.code.flyway.core.BaseMigration;
import com.google.code.flyway.core.DbSupport;
import com.google.code.flyway.core.SqlScript;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class SqlMigration
extends BaseMigration {
    private final Resource sqlScriptResource;
    private final Map<String, String> placeholders;
    private final DbSupport dbSupport;

    public SqlMigration(Resource sqlScriptResource, Map<String, String> placeholders, DbSupport dbSupport) {
        this.initVersion(SqlMigration.extractVersionStringFromFileName(sqlScriptResource.getFilename()));
        this.sqlScriptResource = sqlScriptResource;
        this.placeholders = placeholders;
        this.dbSupport = dbSupport;
    }

    static String extractVersionStringFromFileName(String fileName) {
        int lastDirSeparator = fileName.lastIndexOf("/");
        int extension = fileName.lastIndexOf(".sql");
        return fileName.substring(lastDirSeparator + 1, extension);
    }

    @Override
    public String getScriptName() {
        return "Sql File: " + this.sqlScriptResource.getFilename();
    }

    @Override
    public void doMigrate(SimpleJdbcTemplate jdbcTemplate) {
        SqlScript sqlScript = this.dbSupport.createSqlScript(this.sqlScriptResource, this.placeholders);
        sqlScript.execute(jdbcTemplate);
    }
}

