/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration;

import com.googlecode.flyway.core.util.StringUtils;

public final class SchemaVersion
implements Comparable<SchemaVersion> {
    public static final SchemaVersion EMPTY = new SchemaVersion("<< empty schema >>");
    public static final SchemaVersion LATEST = new SchemaVersion("<< latest >>");
    private final String rawVersion;
    private final String description;

    private SchemaVersion(String rawVersion) {
        this.rawVersion = rawVersion;
        this.description = null;
    }

    public SchemaVersion(String rawVersion, String description) {
        this.description = description;
        this.rawVersion = rawVersion;
    }

    public static SchemaVersion createInitialVersion(String rawVersion, String description) {
        String initDescription;
        String initRawVersion = rawVersion;
        if (initRawVersion == null) {
            initRawVersion = "0";
        }
        if ((initDescription = description) == null) {
            initDescription = "<< Flyway Init >>";
        }
        return new SchemaVersion(initRawVersion, initDescription);
    }

    private String getNormalizedVersion() {
        String[] numbers = this.getElements();
        if (numbers == null) {
            numbers = new String[]{this.rawVersion};
        }
        String versionStr = "";
        for (int i = 0; i < numbers.length; ++i) {
            String s;
            if (i > 0) {
                versionStr = versionStr + ".";
            }
            versionStr = StringUtils.isNumeric(s = numbers[i]) ? versionStr + Long.parseLong(s) : versionStr + s;
        }
        return versionStr;
    }

    public String getVersion() {
        return this.getNormalizedVersion();
    }

    public String getDescription() {
        return this.description;
    }

    private String[] getElements() {
        return StringUtils.split(this.rawVersion, "_.-");
    }

    public String toString() {
        if (this.description == null) {
            return this.rawVersion;
        }
        return this.rawVersion + " (" + this.description + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaVersion that = (SchemaVersion)o;
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        return this.rawVersion.equals(that.rawVersion);
    }

    public int hashCode() {
        int result = this.rawVersion.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(SchemaVersion o) {
        if (o == null) {
            return 1;
        }
        if (this.equals(o)) {
            return 0;
        }
        if (this.equals(EMPTY)) {
            return Integer.MIN_VALUE;
        }
        if (this.equals(LATEST)) {
            return Integer.MAX_VALUE;
        }
        if (o.equals(EMPTY)) {
            return Integer.MAX_VALUE;
        }
        if (o.equals(LATEST)) {
            return Integer.MIN_VALUE;
        }
        String[] elements1 = this.getElements();
        String[] elements2 = o.getElements();
        int max = Math.min(elements1.length, elements2.length);
        for (int i = 0; i < max; ++i) {
            String element1 = elements1[i];
            String element2 = elements2[i];
            int compared = StringUtils.isNumeric(element1) && StringUtils.isNumeric(element2) ? Long.valueOf(element1).compareTo(Long.valueOf(element2)) : element1.compareTo(element2);
            if (compared == 0) continue;
            return compared;
        }
        int result = new Integer(elements1.length).compareTo(elements2.length);
        if (result > 0 && this.justTrailingNull(elements1, max)) {
            return 0;
        }
        if (result < 0 && this.justTrailingNull(elements2, max)) {
            return 0;
        }
        return result;
    }

    private boolean justTrailingNull(String[] elements1, int max) {
        for (int i = max; i < elements1.length; ++i) {
            String element = elements1[i];
            if (StringUtils.isNumeric(element) && Long.valueOf(element).equals(0L)) continue;
            return false;
        }
        return true;
    }
}

