/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.migration.sql;

import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.migration.BaseMigration;
import com.googlecode.flyway.core.migration.sql.PlaceholderReplacer;
import com.googlecode.flyway.core.migration.sql.SqlScript;
import com.googlecode.flyway.core.util.ResourceUtils;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class SqlMigration
extends BaseMigration {
    private final Resource sqlScriptResource;
    private final PlaceholderReplacer placeholderReplacer;
    private final String encoding;

    public SqlMigration(Resource sqlScriptResource, PlaceholderReplacer placeholderReplacer, String encoding, String versionString) {
        this.initVersion(versionString);
        this.scriptName = "Sql File: " + sqlScriptResource.getFilename();
        this.sqlScriptResource = sqlScriptResource;
        this.placeholderReplacer = placeholderReplacer;
        this.encoding = encoding;
    }

    @Override
    public void doMigrate(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport) {
        String sqlScriptSource = ResourceUtils.loadResourceAsString(this.sqlScriptResource, this.encoding);
        SqlScript sqlScript = dbSupport.createSqlScript(sqlScriptSource, this.placeholderReplacer);
        sqlScript.execute(transactionTemplate, jdbcTemplate);
    }
}

