/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.zip.CRC32;
import java.util.zip.CheckedInputStream;
import java.util.zip.Checksum;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.util.FileCopyUtils;

public class ResourceUtils {
    private static final int DEFAULT_BUFFER_SIZE = 4096;

    private ResourceUtils() {
    }

    public static String loadResourceAsString(String location) {
        return ResourceUtils.loadResourceAsString((Resource)new ClassPathResource(location), "UTF-8");
    }

    public static String loadResourceAsString(Resource resource, String encoding) {
        try {
            InputStream inputStream = resource.getInputStream();
            InputStreamReader reader = new InputStreamReader(inputStream, Charset.forName(encoding));
            return FileCopyUtils.copyToString((Reader)reader);
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to load resource: " + resource.getDescription() + " (encoding: " + encoding + ")", e);
        }
    }

    public static long checksum(String location) throws IOException {
        return ResourceUtils.checksum(location, new CRC32()).getValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Checksum checksum(String location, Checksum checksum) throws IOException {
        InputStream in = new ClassPathResource(location).getInputStream();
        try {
            in = new CheckedInputStream(in, checksum);
            ResourceUtils.copyLarge(in, new NullOutputStream());
        }
        finally {
            ResourceUtils.closeQuietly(in);
        }
        return checksum;
    }

    public static long copyLarge(InputStream input, OutputStream output) throws IOException {
        int n;
        byte[] buffer = new byte[4096];
        long count = 0L;
        while (-1 != (n = input.read(buffer))) {
            output.write(buffer, 0, n);
            count += (long)n;
        }
        return count;
    }

    public static void closeQuietly(InputStream input) {
        try {
            if (input != null) {
                input.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static class NullOutputStream
    extends OutputStream {
        private NullOutputStream() {
        }

        @Override
        public void write(byte[] b, int off, int len) {
        }

        @Override
        public void write(int b) {
        }

        @Override
        public void write(byte[] b) throws IOException {
        }
    }
}

