/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core;

import com.googlecode.flyway.core.Migration;
import com.googlecode.flyway.core.MigrationState;
import com.googlecode.flyway.core.SchemaVersion;
import com.googlecode.flyway.core.SqlScript;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class MetaDataTable {
    private static final Log LOG = LogFactory.getLog(MetaDataTable.class);
    private final DbSupport dbSupport;
    private final String tableName;
    private final JdbcTemplate jdbcTemplate;
    private final TransactionTemplate transactionTemplate;

    public MetaDataTable(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport, String tableName) {
        this.transactionTemplate = transactionTemplate;
        this.jdbcTemplate = jdbcTemplate;
        this.dbSupport = dbSupport;
        this.tableName = tableName;
    }

    private boolean exists() {
        return this.dbSupport.metaDataTableExists(this.jdbcTemplate, this.tableName);
    }

    private void create() {
        SqlScript createMetaDataTableScript = this.dbSupport.createCreateMetaDataTableScript(this.tableName);
        createMetaDataTableScript.execute(this.transactionTemplate, this.jdbcTemplate);
        LOG.info((Object)("Metadata table created: " + this.tableName));
    }

    public void init(SchemaVersion initialVersion) {
        if (this.exists()) {
            return;
        }
        this.create();
        final SchemaVersion version = initialVersion == null ? new SchemaVersion("0", null) : initialVersion;
        final Migration initialMigration = new Migration(){
            {
                this.schemaVersion = version;
                this.scriptName = "<< Flyway Init >>";
                this.executionTime = 0;
                this.migrationState = MigrationState.SUCCESS;
            }
        };
        this.transactionTemplate.execute(new TransactionCallback(){

            public Void doInTransaction(TransactionStatus status) {
                MetaDataTable.this.finishMigration(initialMigration);
                return null;
            }
        });
    }

    public void lock() {
        if (this.dbSupport.supportsLocking()) {
            this.jdbcTemplate.queryForList("SELECT script FROM " + this.tableName + " FOR UPDATE");
        }
    }

    public void finishMigration(Migration migration) {
        this.jdbcTemplate.update("UPDATE " + this.tableName + " SET current_version=0");
        this.jdbcTemplate.update("INSERT INTO " + this.tableName + " (version, description, script, execution_time, state, current_version)" + " VALUES (?, ?, ?, ?, ?, 1)", new Object[]{migration.getVersion().getVersion(), migration.getVersion().getDescription(), migration.getScriptName(), migration.getExecutionTime(), migration.getState().name()});
    }

    public Migration latestAppliedMigration() {
        if (!this.exists()) {
            return null;
        }
        final List result = this.jdbcTemplate.queryForList("select VERSION, DESCRIPTION, SCRIPT, EXECUTION_TIME, STATE from " + this.tableName + " where current_version=1");
        if (result.isEmpty()) {
            return new Migration();
        }
        return new Migration(){
            {
                this.schemaVersion = new SchemaVersion((String)((Map)result.get(0)).get("VERSION"), (String)((Map)result.get(0)).get("DESCRIPTION"));
                this.migrationState = MigrationState.valueOf((String)((Map)result.get(0)).get("STATE"));
                this.executionTime = ((Number)((Map)result.get(0)).get("EXECUTION_TIME")).intValue();
                this.scriptName = (String)((Map)result.get(0)).get("SCRIPT");
            }
        };
    }

    public int migrationCount() {
        return this.jdbcTemplate.queryForInt("SELECT COUNT(*) FROM " + this.tableName);
    }
}

