/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core;

import com.googlecode.flyway.core.MigrationState;
import com.googlecode.flyway.core.SchemaVersion;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;
import org.springframework.util.StopWatch;

public class Migration {
    protected SchemaVersion schemaVersion = SchemaVersion.EMPTY;
    protected MigrationState migrationState = MigrationState.UNKNOWN;
    protected int executionTime = -1;
    protected String scriptName;

    public SchemaVersion getVersion() {
        return this.schemaVersion;
    }

    public MigrationState getState() {
        return this.migrationState;
    }

    public long getExecutionTime() {
        return this.executionTime;
    }

    public String getScriptName() {
        return this.scriptName;
    }

    public void assertNotFailed() {
        if (MigrationState.FAILED == this.migrationState) {
            throw new IllegalStateException("Migration to version " + this.schemaVersion + " failed! Please restore backups and roll back database and code!");
        }
    }

    public final void migrate(final TransactionTemplate transactionTemplate, final JdbcTemplate jdbcTemplate, final DbSupport dbSupport) {
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                try {
                    Migration.this.doMigrate(transactionTemplate, jdbcTemplate, dbSupport);
                    Migration.this.migrationState = MigrationState.SUCCESS;
                }
                catch (Exception e) {
                    Migration.this.migrationState = MigrationState.FAILED;
                }
            }
        };
        Thread migrationThread = new Thread(runnable, "Flyway Migration");
        migrationThread.start();
        try {
            migrationThread.join();
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        stopWatch.stop();
        this.executionTime = (int)stopWatch.getLastTaskTimeMillis();
    }

    protected void doMigrate(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport) throws DataAccessException {
    }
}

