/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core;

import java.util.Arrays;

public final class SchemaVersion
implements Comparable<SchemaVersion> {
    public static final SchemaVersion EMPTY = new SchemaVersion("<< empty schema >>");
    public static final SchemaVersion LATEST = new SchemaVersion("<< latest >>");
    private final long[] components;
    private final String version;
    private final String description;

    private SchemaVersion(String version) {
        this.version = version;
        this.components = new long[0];
        this.description = null;
    }

    public SchemaVersion(String rawVersion, String description) {
        this.description = description;
        String[] numbers = rawVersion.split("\\.");
        if (numbers == null) {
            numbers = new String[]{rawVersion};
        }
        String versionStr = "";
        this.components = new long[numbers.length];
        for (int i = 0; i < numbers.length; ++i) {
            this.components[i] = Long.parseLong(numbers[i]);
            if (i > 0) {
                versionStr = versionStr + ".";
            }
            versionStr = versionStr + this.components[i];
        }
        this.version = versionStr;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        if (this.description == null) {
            return this.version;
        }
        return this.version + " (" + this.description + ")";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaVersion that = (SchemaVersion)o;
        if (!Arrays.equals(this.components, that.components)) {
            return false;
        }
        if (this.description != null ? !this.description.equals(that.description) : that.description != null) {
            return false;
        }
        return this.version.equals(that.version);
    }

    public int hashCode() {
        int result = this.components != null ? Arrays.hashCode(this.components) : 0;
        result = 31 * result + this.version.hashCode();
        result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(SchemaVersion o) {
        if (o == null) {
            return 1;
        }
        if (this.equals(o)) {
            return 0;
        }
        if (this.equals(EMPTY)) {
            return Integer.MIN_VALUE;
        }
        if (this.equals(LATEST)) {
            return Integer.MAX_VALUE;
        }
        if (o.equals(EMPTY)) {
            return Integer.MAX_VALUE;
        }
        if (o.equals(LATEST)) {
            return Integer.MIN_VALUE;
        }
        int maxComponents = Math.max(this.components.length, o.components.length);
        for (int i = 0; i < maxComponents; ++i) {
            long myComponent = 0L;
            if (i < this.components.length) {
                myComponent = this.components[i];
            }
            long otherComponent = 0L;
            if (i < o.components.length) {
                otherComponent = o.components[i];
            }
            if (myComponent > otherComponent) {
                return 1;
            }
            if (myComponent >= otherComponent) continue;
            return -1;
        }
        return 0;
    }
}

