/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core;

import com.googlecode.flyway.core.SqlStatement;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.TransactionStatus;
import org.springframework.transaction.support.TransactionCallback;
import org.springframework.transaction.support.TransactionTemplate;

public class SqlScript {
    private static final Log LOG = LogFactory.getLog(SqlScript.class);
    private static final String DEFAULT_STATEMENT_DELIMITER = ";";
    private String name;
    private final List<SqlStatement> sqlStatements;

    public SqlScript(Resource resource, Map<String, String> placeholders) {
        InputStreamReader reader = null;
        try {
            reader = new InputStreamReader(resource.getInputStream(), "UTF-8");
            List<String> rawLines = this.readLines(reader);
            List<String> trimmedLines = this.trimLines(rawLines);
            List<String> noCommentLines = this.stripSqlComments(trimmedLines);
            List<String> noPlaceholderLines = this.replacePlaceholders(noCommentLines, placeholders);
            this.sqlStatements = this.linesToStatements(noPlaceholderLines);
            this.name = resource.getFilename();
        }
        catch (IOException e) {
            throw new IllegalStateException("Unable to read sql script: " + resource.getFilename(), e);
        }
        finally {
            if (reader != null) {
                try {
                    ((Reader)reader).close();
                }
                catch (IOException e) {}
            }
        }
    }

    public SqlScript(List<SqlStatement> sqlStatements, String name) {
        this.sqlStatements = sqlStatements;
        this.name = name;
    }

    protected SqlScript() {
        this.sqlStatements = null;
        this.name = null;
    }

    public List<SqlStatement> getSqlStatements() {
        return this.sqlStatements;
    }

    public void execute(TransactionTemplate transactionTemplate, final JdbcTemplate jdbcTemplate) {
        LOG.info((Object)("Executing " + this.name));
        transactionTemplate.execute(new TransactionCallback(){

            public Void doInTransaction(TransactionStatus status) {
                for (SqlStatement sqlStatement : SqlScript.this.sqlStatements) {
                    sqlStatement.execute(jdbcTemplate);
                }
                return null;
            }
        });
    }

    List<SqlStatement> linesToStatements(List<String> lines) {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        int statementLineNumber = 0;
        String statementSql = "";
        String delimiter = DEFAULT_STATEMENT_DELIMITER;
        for (int lineNumber = 1; lineNumber <= lines.size(); ++lineNumber) {
            String line = lines.get(lineNumber - 1);
            if (line.isEmpty()) continue;
            if (statementSql.isEmpty()) {
                statementLineNumber = lineNumber;
            } else {
                statementSql = statementSql + " ";
            }
            statementSql = statementSql + line;
            String newDelimiter = this.checkForNewDelimiter(line);
            if (newDelimiter != null) {
                delimiter = newDelimiter;
            }
            if (!line.endsWith(delimiter)) continue;
            String noDelimiterStatementSql = SqlScript.stripDelimiter(statementSql, delimiter);
            statements.add(new SqlStatement(statementLineNumber, noDelimiterStatementSql));
            LOG.debug((Object)("Found statement at line " + statementLineNumber + ": " + statementSql));
            delimiter = DEFAULT_STATEMENT_DELIMITER;
            statementSql = "";
        }
        if (!statementSql.isEmpty()) {
            statements.add(new SqlStatement(statementLineNumber, statementSql));
        }
        return statements;
    }

    protected String checkForNewDelimiter(String line) {
        return null;
    }

    private static String stripDelimiter(String sql, String delimiter) {
        return sql.substring(0, sql.length() - delimiter.length());
    }

    List<String> stripSqlComments(List<String> lines) {
        ArrayList<String> noCommentLines = new ArrayList<String>(lines.size());
        boolean inMultilineComment = false;
        for (String line : lines) {
            String trimmedLine = line.trim();
            if (trimmedLine.startsWith("--")) {
                noCommentLines.add("");
                continue;
            }
            if (trimmedLine.startsWith("/*")) {
                inMultilineComment = true;
            }
            if (inMultilineComment) {
                if (trimmedLine.endsWith("*/")) {
                    inMultilineComment = false;
                }
                noCommentLines.add("");
                continue;
            }
            noCommentLines.add(trimmedLine);
        }
        return noCommentLines;
    }

    private List<String> trimLines(List<String> lines) {
        ArrayList<String> trimmedLines = new ArrayList<String>(lines.size());
        for (String line : lines) {
            String trimmedLine = line.trim();
            trimmedLines.add(trimmedLine);
        }
        return trimmedLines;
    }

    private List<String> readLines(Reader reader) {
        ArrayList<String> lines = new ArrayList<String>();
        BufferedReader bufferedReader = new BufferedReader(reader);
        try {
            String line;
            while ((line = bufferedReader.readLine()) != null) {
                lines.add(line);
            }
        }
        catch (IOException e) {
            throw new IllegalStateException("Cannot parse lines", e);
        }
        return lines;
    }

    private List<String> replacePlaceholders(List<String> lines, Map<String, String> placeholders) {
        ArrayList<String> noPlaceholderLines = new ArrayList<String>(lines.size());
        Iterator<String> i$ = lines.iterator();
        while (i$.hasNext()) {
            String line;
            String noPlaceholderLine = line = i$.next();
            for (String placeholder : placeholders.keySet()) {
                String searchTerm = "${" + placeholder + "}";
                noPlaceholderLine = noPlaceholderLine.replaceAll(Pattern.quote(searchTerm), Matcher.quoteReplacement(placeholders.get(placeholder)));
            }
            noPlaceholderLines.add(noPlaceholderLine);
        }
        return noPlaceholderLines;
    }
}

