/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.h2;

import com.googlecode.flyway.core.SqlScript;
import com.googlecode.flyway.core.SqlStatement;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class H2DbSupport
implements DbSupport {
    @Override
    public SqlScript createCreateMetaDataTableScript(String tableName) {
        ClassPathResource resource = new ClassPathResource("com/googlecode/flyway/core/dbsupport/h2/createMetaDataTable.sql");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("tableName", tableName);
        return new SqlScript((Resource)resource, placeholders);
    }

    @Override
    public String getCurrentSchema(JdbcTemplate jdbcTemplate) {
        return (String)jdbcTemplate.execute(new ConnectionCallback(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getSchemas();
                while (resultSet.next()) {
                    if (!resultSet.getBoolean("IS_DEFAULT")) continue;
                    return resultSet.getString("TABLE_SCHEM");
                }
                return null;
            }
        });
    }

    @Override
    public boolean supportsDatabase(String databaseProductName) {
        return "H2".equals(databaseProductName);
    }

    @Override
    public boolean metaDataTableExists(final JdbcTemplate jdbcTemplate, final String schemaMetaDataTable) {
        return (Boolean)jdbcTemplate.execute(new ConnectionCallback(){

            public Boolean doInConnection(Connection connection) throws SQLException, DataAccessException {
                ResultSet resultSet = connection.getMetaData().getTables(null, H2DbSupport.this.getCurrentSchema(jdbcTemplate), schemaMetaDataTable.toUpperCase(), null);
                return resultSet.next();
            }
        });
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsLocking() {
        return true;
    }

    @Override
    public SqlScript createSqlScript(Resource resource, Map<String, String> placeholders) {
        return new SqlScript(resource, placeholders);
    }

    @Override
    public SqlScript createCleanScript(JdbcTemplate jdbcTemplate) {
        return new SqlScript(new ArrayList<SqlStatement>(), "Clean schema " + this.getCurrentSchema(jdbcTemplate));
    }
}

