/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.dbsupport.oracle;

import com.googlecode.flyway.core.SqlScript;
import com.googlecode.flyway.core.SqlStatement;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import com.googlecode.flyway.core.dbsupport.oracle.OracleSqlScript;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.ConnectionCallback;
import org.springframework.jdbc.core.JdbcTemplate;

public class OracleDbSupport
implements DbSupport {
    @Override
    public SqlScript createCreateMetaDataTableScript(String tableName) {
        ClassPathResource resource = new ClassPathResource("com/googlecode/flyway/core/dbsupport/oracle/createMetaDataTable.sql");
        HashMap<String, String> placeholders = new HashMap<String, String>();
        placeholders.put("tableName", tableName);
        return new SqlScript((Resource)resource, placeholders);
    }

    @Override
    public String getCurrentSchema(JdbcTemplate jdbcTemplate) {
        return (String)jdbcTemplate.execute(new ConnectionCallback(){

            public String doInConnection(Connection connection) throws SQLException, DataAccessException {
                return connection.getMetaData().getUserName();
            }
        });
    }

    @Override
    public boolean supportsDatabase(String databaseProductName) {
        return "Oracle".equals(databaseProductName);
    }

    @Override
    public boolean metaDataTableExists(JdbcTemplate jdbcTemplate, String schemaMetaDataTable) {
        int count = jdbcTemplate.queryForInt("SELECT count(*) FROM user_tables WHERE table_name = ?", new Object[]{schemaMetaDataTable.toUpperCase()});
        return count > 0;
    }

    @Override
    public boolean supportsDdlTransactions() {
        return false;
    }

    @Override
    public boolean supportsLocking() {
        return true;
    }

    @Override
    public SqlScript createSqlScript(Resource resource, Map<String, String> placeholders) {
        return new OracleSqlScript(resource, placeholders);
    }

    @Override
    public SqlScript createCleanScript(JdbcTemplate jdbcTemplate) {
        String query = "SELECT 'DROP ' ||  object_type ||' ' || object_name || ' ' || DECODE(OBJECT_TYPE,'TABLE','CASCADE CONSTRAINTS PURGE') FROM user_objects WHERE object_type IN ('FUNCTION','MATERIALIZED VIEW','PACKAGE','PROCEDURE','SEQUENCE','SYNONYM','TABLE','TYPE','VIEW') order by object_type desc";
        List resultSet = jdbcTemplate.queryForList(query);
        int count = 0;
        ArrayList<SqlStatement> sqlStatements = new ArrayList<SqlStatement>();
        for (Map row : resultSet) {
            String dropStatement = (String)row.values().iterator().next();
            sqlStatements.add(new SqlStatement(++count, dropStatement));
        }
        return new SqlScript(sqlStatements, "oracle drop all objects script");
    }
}

