/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.java;

import com.googlecode.flyway.core.Migration;
import com.googlecode.flyway.core.MigrationResolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Set;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.annotation.ClassPathScanningCandidateComponentProvider;
import org.springframework.core.type.filter.AssignableTypeFilter;
import org.springframework.core.type.filter.TypeFilter;
import org.springframework.util.ClassUtils;

public class JavaMigrationResolver
implements MigrationResolver {
    private final String basePackage;

    public JavaMigrationResolver(String basePackage) {
        this.basePackage = basePackage;
    }

    @Override
    public Collection<Migration> resolvesMigrations() {
        ArrayList<Migration> migrations = new ArrayList<Migration>();
        ClassPathScanningCandidateComponentProvider provider = new ClassPathScanningCandidateComponentProvider(false);
        provider.addIncludeFilter((TypeFilter)new AssignableTypeFilter(Migration.class));
        Set components = provider.findCandidateComponents(this.basePackage);
        for (BeanDefinition beanDefinition : components) {
            Class clazz = ClassUtils.resolveClassName((String)beanDefinition.getBeanClassName(), null);
            Migration migration = (Migration)BeanUtils.instantiateClass((Class)clazz);
            migrations.add(migration);
        }
        return migrations;
    }
}

