/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.flyway.core.sql;

import com.googlecode.flyway.core.BaseMigration;
import com.googlecode.flyway.core.SqlScript;
import com.googlecode.flyway.core.dbsupport.DbSupport;
import java.util.Map;
import org.springframework.core.io.Resource;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.transaction.support.TransactionTemplate;

public class SqlMigration
extends BaseMigration {
    private final Resource sqlScriptResource;
    private final Map<String, String> placeholders;

    public SqlMigration(Resource sqlScriptResource, Map<String, String> placeholders) {
        this.initVersion(SqlMigration.extractVersionStringFromFileName(sqlScriptResource.getFilename()));
        this.scriptName = "Sql File: " + sqlScriptResource.getFilename();
        this.sqlScriptResource = sqlScriptResource;
        this.placeholders = placeholders;
    }

    static String extractVersionStringFromFileName(String fileName) {
        int lastDirSeparator = fileName.lastIndexOf("/");
        int extension = fileName.lastIndexOf(".sql");
        return fileName.substring(lastDirSeparator + 1, extension);
    }

    @Override
    public void doMigrate(TransactionTemplate transactionTemplate, JdbcTemplate jdbcTemplate, DbSupport dbSupport) {
        SqlScript sqlScript = dbSupport.createSqlScript(this.sqlScriptResource, this.placeholders);
        sqlScript.execute(transactionTemplate, jdbcTemplate);
    }
}

